/*
	remotetypograf.h
	C++ declaration of ArtLebedevStudio.RemoteTypograf class (web-service client)
	
	Copyright (c) Art. Lebedev Studio | http://www.artlebedev.ru/

	Typograf homepage: http://typograf.artlebedev.ru/
	Web-service address: http://typograf.artlebedev.ru/webservices/typograf.asmx
	WSDL-description: http://typograf.artlebedev.ru/webservices/typograf.asmx?WSDL
	
	Default charset: Windows-1251

	Version: 1.0 (August 30, 2005)
	Author: Andrew Shitov (ash@design.ru)


	Example:
		ArtLebedevStudio::RemoteTypograf *remoteTypograf = new ArtLebedevStudio::RemoteTypograf();
		cout << remoteTypograf->processText ("\"   - \n  \"\"? -     !\"") << "\n";
*/

#include <string>

namespace ArtLebedevStudio
{
	class RemoteTypograf
	{
	private:
		int _entityType;
		int _useBr;
		int _useP;
		int _maxNobr;

	public:
		RemoteTypograf();

		void htmlEntities() {_entityType = 1;}
		void xmlEntities() {_entityType = 2;}
		void mixedEntities() {_entityType = 4;}
		void noEntities() {_entityType = 3;}
		void br (const bool value) {_useBr = value;}
		void p (const bool value) {_useP = value;}
		void nobr (const int value) {_maxNobr = value ? value : 0;}	

		std::string processText (std::string) const;
	private:
		std::string RemoteTypograf::replaceSubstring (const std::string& text, const std::string from, const std::string to) const;
	};
}
