/*
	remotetypograf.cpp
	Version: 1.0 (August 30, 2005)
	
	Copyright (c) Art. Lebedev Studio | http://www.artlebedev.ru/
*/

#ifdef unix
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netdb.h>
#else
#include <winsock2.h>
#endif

#include <stdio.h>
#include <string>
#include <sstream>

#include "remotetypograf.h"

using namespace std;
using namespace ArtLebedevStudio;

RemoteTypograf::RemoteTypograf()
{
	_entityType = 4;
	_useBr = 1;
	_useP = 1;
	_maxNobr = 3;
}

string RemoteTypograf::processText (string text) const
{	
	struct sockaddr_in service;
	service.sin_family = AF_INET;
	service.sin_port = htons (80);

	#ifndef unix
	WORD wVersionRequested;
	WSADATA wsaData;
	wVersionRequested = MAKEWORD (2, 2);
	WSAStartup (wVersionRequested, &wsaData);
	#endif

	struct hostent* hostinfo = gethostbyname ("typograf.artlebedev.ru");

	/*struct hostent hostinfo;
	struct hostent *hp;
	int retval;
	char hbuf[8192];
	gethostbyname_r ("typograf.artlebedev.ru", &hostinfo, hbuf, sizeof (hbuf), &retval);*/

	if (hostinfo)
	{
		service.sin_addr = *((struct in_addr*) hostinfo->h_addr);
		int socket_handle = socket (PF_INET, SOCK_STREAM, 0);
	
		if (connect (socket_handle, (sockaddr*) &service, sizeof (struct sockaddr_in)) != -1)
		{
			text = replaceSubstring (text, "&", "&amp;");
			text = replaceSubstring (text, "<", "&lt;");
			text = replaceSubstring (text, ">", "&gt;");

			stringstream soapbody;
			soapbody << "<?xml version=\"1.0\" encoding=\"Windows-1251\"?>\n"
				"<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">"
				"  <soap:Body>"
				"	<ProcessText xmlns=\"http://typograf.artlebedev.ru/webservices/\">"
				"	  <text>" << text << "</text>"
				"	  <entityType>" << _entityType << "</entityType>"
				"	  <useBr>" << _useBr << "</useBr>"
				"	  <useP>" << _useP << "</useP>"
				"	  <maxNobr>" << _maxNobr << "</maxNobr>"
				"	</ProcessText>"
				" </soap:Body>"
				"</soap:Envelope>";

			stringstream request;
			request	<< "POST /webservices/typograf.asmx HTTP/1.1\n"
					"Host: typograf.artlebedev.ru\n"
					"Content-Length: " << soapbody.str().length() << "\n\n" 
					<< soapbody.str();
			
			#ifdef unix
			write (socket_handle, request.str().c_str(), request.str().length());
			#else
			send (socket_handle, request.str().c_str(), request.str().length(), 0);
			#endif			
			
			char buffer[8193];
			string response;
			
			while
			(
				#ifdef unix
				read (socket_handle, buffer, 8192)
				#else
				recv (socket_handle, buffer, 8192, 0)
				#endif
			)
			response += buffer;

			int startsAt = response.find ("<ProcessTextResult>") + 19;
			int endsAt = response.rfind ("</ProcessTextResult>");
			
			string typographed = response.substr (startsAt, endsAt - startsAt - 1);

			typographed = replaceSubstring (typographed, "&amp;", "&");
			typographed = replaceSubstring (typographed, "&lt;", "<");
			typographed = replaceSubstring (typographed, "&gt;", ">");

			return typographed;
		}
		else {return "?";}
	}
	return "1";	
}

string RemoteTypograf::replaceSubstring (const string& text, const string from, const string to) const
{	
	string ret ("");
	int pos;
	int prev = 0;
	int len = from.length();
	while ((pos = text.find (from, prev)) != string::npos)
	{
		ret += text.substr (prev, pos - prev) + to;
		prev = pos + len;
	}
	return ret + text.substr (prev);
}
