@CLASS
RemoteTypograf

#	remotetypograf.p
#	Parser 3 implementation of ArtLebedevStudio.RemoteTypograf class (web-service client)
#	
#	Copyright (c) Art. Lebedev Studio | http://www.artlebedev.ru/
#
#	Typograf homepage: http://typograf.artlebedev.ru/
#	Web-service address: http://typograf.artlebedev.ru/webservices/typograf.asmx
#	WSDL-description: http://typograf.artlebedev.ru/webservices/typograf.asmx?WSDL
#	
#	Default charset: UTF-8
#
#	Version: 1.0 (August 30, 2005)
#	Version: 1.1 (March 16, 2006)
#		Removing whitespaces after transformation.
#
#	Author: Andrew Shitov (ash@design.ru)
#
#
#	Example:
#		$remoteTypograf[^RemoteTypograf::new[]]
#		^remoteTypograf.processText[$form:text]
#
#	Works under Parser 1.2+



@new[]
	$_entityType(4)
	$_useBr(1)
	$_useP(1)
	$_maxNobr(3)
	$_parserOutput(0)


@htmlEntities[]
	$_entityType(1)


@xmlEntities[]
	$_entityType(2)


@mixedEntities[]
	$_entityType(4)


@noEntities[]
	$_entityType(3)


@br[value]
	$_useBr($value)


@p[value]
	$_useP($value)


@nobr[value]
	$_maxNobr($value)


@parserOutput[]
	$_parserOutput(1)


@processText[text]
	$text[^text.match[&][g]{&amp^;}]
	$text[^text.match[<][g]{&lt^;}]
	$text[^text.match[>][g]{&gt^;}]

	$SOAPBody[<?xml version="1.0" encoding="utf-8"?>
<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
	<soap:Body>
		<ProcessText xmlns="http://typograf.artlebedev.ru/webservices/">
			<text>$text</text>
			<entityType>$_entityType</entityType>
			<useBr>$_useBr</useBr>
			<useP>$_useP</useP>
			<maxNobr>$_maxNobr</maxNobr>
		</ProcessText>
	</soap:Body>
</soap:Envelope>]
		
	$remoteTypograf[^file::load[binary;http://typograf.artlebedev.ru/webservices/typograf.asmx?parserClient;
		$.method[POST]
		$.body[^untaint[as-is]{$SOAPBody}]
		$.charset[utf-8]
	]]

	
	$soapResponse[^xdoc::create{^untaint[as-is]{$remoteTypograf.text}}]
	$soapEnvelope[$soapResponse.documentElement]
	$soapResponse.search-namespaces.als[http://typograf.artlebedev.ru/webservices/]
	$ProcessTextResult[^soapEnvelope.selectSingle[//als:ProcessTextResult/text()]]
	^if(def $ProcessTextResult){
		$typographed[$ProcessTextResult.nodeValue]
		$typographed[^typographed.match[&amp^;][g]{&}]
		$typographed[^typographed.match[&lt^;][g]{<}]
		$typographed[^typographed.match[&gt^;][g]{>}]
		^if($_parserOutput){
			$typographed[^typographed.match[^;][g]{^^^;}]
		}
		$retvalue[^untaint[as-is]{$typographed}]
		$result[^retvalue.trim[]]
	}{
		$result[]
	}