/*
// 2006-02-20
// Copyright (c) Art. Lebedev | http://www.artlebedev.ru/
// Author - Vladimir Tokmakov
*/

var to_iMax_num_profiles = 6;
var to_hControl = new Array();
var to_hLabels = new Array();
to_hLabels.User_profile = '';
to_hLabels.Back_to_typograf = '';
to_hLabels.Typograf_options = '';

function toInit_Typograph_options_form(){
	if( window.parent.frames.length > 0 && window.parent.document.getElementById( 'profiles_sheet' ) ){
		window.parent.toMake_Typograf_options_form();
	}else{
		toMake_Typograph_options_form();
	}
}

function toMake_Typograph_options_form(){
	toInit_Control_hash();

	to_hControl.Block.Example_parent = document.getElementById( 'profiles_sheet' );

	to_hControl.Input.New_profile = document.getElementById( 'to_new_profile' ).firstChild;
	to_hControl.Input.Rename_profile = document.getElementById( 'to_rename_profile' ).firstChild;
	to_hControl.Input.Rename_profile.onblur = toRename_profile;

	to_hControl.Button.Add_profile = document.getElementById( 'to_add_profile' ).firstChild;
	to_hControl.Button.Add_profile.onclick = toAdd_profile;
	to_hControl.Button.Delete_profile = document.getElementById( 'to_delete_profile' ).firstChild;
	to_hControl.Button.Delete_profile.onclick = toDelete_profile;

	toInit_Typograph_options_inputs();

	to_hControl.Input.New_profile.onkeyup = toSet_disabled_for_new_profile_button;
	to_hControl.Input.New_profile.onkeyup();

	document.getElementById( oTypograph_options.sDefault_profile_name ).onmousedown = toTypograph_options_profile_tab_onclick;
	oTypograph_options.sPrevious_profile_name = '-vlalek-';
	var i = toMake_Typograph_options_profiles_tabs();
	if( i == 1 ){
		var sOld_profile_name = to_hControl.Input.New_profile.value;
		to_hControl.Input.New_profile.value = to_hLabels.User_profile;
		toAdd_profile();
		to_hControl.Input.New_profile.value = sOld_profile_name;
	}
	cmnAdd_event( window, 'focus', toMake_Typograph_options_profiles_tabs );
}

function toSet_disabled_for_new_profile_button(){
	this.value = this.value.replace( /,/g, '' )
	to_hControl.Button.Add_profile.disabled = this.value == ''
}

function toDelete_profile(){
	var eLI = document.getElementById( oTypograph_options.sCurrent_profile_name )
	if( oTypograph_options.Remove_current_profile() ){
		eLI.parentNode.removeChild( eLI )
		document.getElementById( oTypograph_options.sCurrent_profile_name ).onmousedown()
	}
	to_hControl.Input.New_profile.disabled = to_hControl.Block.Profiles_list.childNodes.length >= to_iMax_num_profiles
}

function toAdd_profile(){
	var sNew_profile_name = oTypograph_options.Clone_current_profile( to_hControl.Input.New_profile.value )
	if( sNew_profile_name  ){
		var eNew_profile_tab = toAdd_profile_tab( sNew_profile_name, to_hControl.Input.New_profile.value )
		eNew_profile_tab.onmousedown = toTypograph_options_profile_tab_onclick
		eNew_profile_tab.onmousedown()

		to_hControl.Input.New_profile.value = ''
		to_hControl.Input.New_profile.onkeyup()
	}
}

function toMake_Typograph_options_profiles_tabs(){
	while( to_hControl.Block.Profiles_list.childNodes.length > 2 ){
		to_hControl.Block.Profiles_list.removeChild( to_hControl.Block.Profiles_list.childNodes[1] );
	}
	cmnRemove_class( to_hControl.Block.Profiles_list.firstChild, 'current' );
	oTypograph_options.refresh();
	var asProfile = oTypograph_options.Get_profiles();
	var eTmp;
	for( var i = 1 ; i < asProfile.length; i++ ){
		eTmp = toAdd_profile_tab( oTypograph_options.sPrefix_profile_name + i, asProfile[i] );
		eTmp.onmousedown = toTypograph_options_profile_tab_onclick;
	}
	cmnSet_class( document.getElementById( oTypograph_options.sCurrent_profile_name ), 'current' );
	if( oTypograph_options.sCurrent_profile_name != oTypograph_options.sPrevious_profile_name ){
		oTypograph_options.sPrevious_profile_name = oTypograph_options.sCurrent_profile_name;
		document.getElementById( oTypograph_options.sCurrent_profile_name ).onmousedown();
	}
}

function toTypograph_options_profile_tab_onclick(){
	oTypograph_options.Set_current_profile( this.id );

	var aeProfiles_tab = to_hControl.Block.Profiles_list.childNodes;
	for( var i = aeProfiles_tab.length - 1 ; --i >= 0 ; ){
		aeProfiles_tab[i].id = oTypograph_options.sPrefix_profile_name + i;
		if( aeProfiles_tab[i].id == this.id ){
			cmnSet_class( aeProfiles_tab[i], 'current' );
		}else{
			cmnSet_class( aeProfiles_tab[i], '', 'current' );
		}
	}

	toRefresh_options_sheet();
}

/* typograf */

function toInit_Typograf_form(){
	toInit_Control_hash();

	to_hControl.Form = document.getElementById( 'typograf' ).getElementsByTagName( 'form' )[0];
	to_hControl.Form.onsubmit = toTypograf_form_onsubmit;

	to_hControl.Input.Typograph_text = document.getElementById( 'text' );
	to_hControl.Input.Typograph_text.onkeyup = toSet_disabled_for_typograf_buttons;
	to_hControl.Input.Typograph_text.mouseup = toSet_disabled_for_typograf_buttons;

	to_hControl.Button.Submit = document.getElementById( 'go' );
	to_hControl.Button.Reset = document.getElementById( 'reset' );
	to_hControl.Button.Reset.onclick = toTypograf_reset;

	to_hControl.Input.Typograph_text.mouseup();

	document.getElementById( oTypograph_options.sDefault_profile_name ).onmousedown = toTypograf_profile_tab_onclick;
	toMake_Typograf_profiles_tabs();
	cmnAdd_event( window, 'focus', toMake_Typograf_profiles_tabs );
}

function toShow_Typograf_options( eThis ){
	if( eProfiles.firstChild ){
		if( to_hControl.Form.offsetHeight ){
			toRefresh_options_sheet();
			to_hControl.Form.style.display = 'none';
			to_hControl.Block.Profiles_sheet.style.display = 'block';
		}else{
			to_hControl.Form.style.display = 'block';
			to_hControl.Block.Profiles_sheet.style.display = 'none';
		}
	}
	eThis.innerHTML = !eProfiles.firstChild || !to_hControl.Form.offsetHeight ? to_hLabels.Back_to_typograf : to_hLabels.Typograf_options;
	return !to_hControl.Block.Profiles_sheet.firstChild;
}

function toMake_Typograf_options_form(){
	to_hControl.Form.style.display = 'none';
	var eIFRAME = document.getElementsByTagName( 'iframe' )[0]
	var eDocument =  eIFRAME.contentWindow ? eIFRAME.contentWindow.document : eIFRAME.contentDocument;
	document.getElementById( 'profiles_sheet' ).innerHTML = eDocument.getElementById( 'profiles_sheet' ).innerHTML;
	to_hControl.Input.Rename_profile = document.getElementById( 'to_rename_profile' ).firstChild;
	to_hControl.Input.Rename_profile.onblur = toRename_profile;
	toInit_Typograph_options_inputs();
	toRefresh_options_sheet();
}


function toMake_Typograf_profiles_tabs(){
	while( to_hControl.Block.Profiles_list.childNodes.length > 2 ){
		to_hControl.Block.Profiles_list.removeChild( to_hControl.Block.Profiles_list.childNodes[1] );
	}
	cmnRemove_class( to_hControl.Block.Profiles_list.firstChild, 'current' );
	oTypograph_options.refresh();
	var asProfile = oTypograph_options.Get_profiles();
	var eTmp, eButton;
	for( var i = 1 ; i < asProfile.length; i++ ){
		eTmp = toAdd_profile_tab( oTypograph_options.sPrefix_profile_name + i, asProfile[i] );
		/*eButton = document.createElement( 'button' );
		cmnAdd_button_events( eButton );
		eTmp.appendChild( eButton );*/
		eTmp.onmousedown = toTypograf_profile_tab_onclick;
	}
	cmnSet_class( document.getElementById( oTypograph_options.sCurrent_profile_name ), 'current' );
	if( !to_hControl.Form.offsetHeight ){
		if( oTypograph_options.sCurrent_profile_name != oTypograph_options.sPrevious_profile_name ){
			oTypograph_options.sPrevious_profile_name = oTypograph_options.sCurrent_profile_name;
			document.getElementById( oTypograph_options.sCurrent_profile_name ).onmousedown();
		}
	}
}

function toTypograf_profile_tab_onclick(){
	oTypograph_options.Set_current_profile( this.id );

	var aeProfiles_tab = to_hControl.Block.Profiles_list.childNodes;
	for( var i = aeProfiles_tab.length - 1 ; --i >= 0 ; ){
		aeProfiles_tab[i].id = oTypograph_options.sPrefix_profile_name + i;
		if( aeProfiles_tab[i].id == this.id ){
			cmnSet_class( aeProfiles_tab[i], 'current' );
		}else{
			cmnSet_class( aeProfiles_tab[i], '', 'current' );
		}
	}
	if( to_hControl.Form.offsetHeight ){
		if( to_hControl.Input.Typograph_text && to_hControl.Input.Typograph_text.value ){
			to_hControl.Form.onsubmit();
			to_hControl.Button.Submit.disabled = true;
			to_hControl.Button.Reset.disabled = true;
			to_hControl.Form.submit()
		}
	}else{
		toRefresh_options_sheet();
	}
}

function toTypograf_reset(){
	to_hControl.Input.Typograph_text.value = '';
	toSet_disabled_for_typograf_buttons();
}

function toSet_disabled_for_typograf_buttons(){
	/*if( to_hControl.Input.Typograph_text.value ){
		to_hControl.Button.Submit.disabled = false
		to_hControl.Button.Reset.disabled = false
	}else{
		to_hControl.Button.Submit.disabled = true
		to_hControl.Button.Reset.disabled = true
	}
	to_hControl.Input.Typograph_text.className += ''*/
}

function toTypograf_form_onsubmit(){
	if( to_hControl.Input.Typograph_text.value ){
		this.options.value = oTypograph_options.Get_option_values_as_string();
		return true;
	}else{
		return false;
	}
}

/* common */

function toRename_profile(){
	if( this.value.replace( /\s+/g, '' ) != '' && oTypograph_options.Rename_current_profile( this.value ) ){
		document.getElementById( oTypograph_options.sCurrent_profile_name ).innerHTML = this.value;
	}
}

function toAdd_profile_tab( sID, sName ){
	var eLI = document.createElement( 'li' )
	eLI.id = sID
	cmnSet_class( eLI, 'tab' )
	eLI.innerHTML = sName

	to_hControl.Block.Profiles_list.insertBefore(  eLI, to_hControl.Block.Profiles_list.lastChild )
	if( to_hControl.Input.New_profile ){
		to_hControl.Input.New_profile.disabled = to_hControl.Block.Profiles_list.childNodes.length >= to_iMax_num_profiles
	}
	return eLI
}

function toInit_Control_hash(){
	to_hControl.Block = new Array();
	to_hControl.Block.Profiles_list = document.getElementById( 'profiles_list' );
	to_hControl.Block.Profiles_sheet = document.getElementById( 'profiles_sheet' );
	to_hControl.Input = new Array();
	to_hControl.Button = new Array();
}

function toRefresh_options_sheet(){
	var eOn, i, ii, j, sValue;
	var bDisabled = ( oTypograph_options.sCurrent_profile_name == oTypograph_options.sDefault_profile_name ) ? true : false;
	//to_hControl.Block.Profiles_sheet.setAttribute( 'disabled', bDisabled );
	for( var sName in oTypograph_options.Names ){
		sValue = oTypograph_options.Get_option( sName );
		eOn = document.getElementById( 'to_' + sName );
		if( eOn ){
			if( eOn.nodeName.toLowerCase() == 'input' ){
				if( eOn.getAttribute( 'type' ) == 'text' ){
					eOn.value = sValue;
					eOn.onblur();
				}else{
					eOn.checked = sValue && sValue != 'false' ? true : false;
					eOn.checked = eOn.value != 0 ? eOn.checked : !eOn.checked;
					eOn.onclick();
				}
				eOn.disabled = bDisabled;
				eOn.parentNode.setAttribute( 'disabled', bDisabled );
			}else if( eOn.nodeName.toLowerCase() == 'textarea' ){
				eOn.value = sValue;
				eOn.onblur();
				eOn.disabled = bDisabled;
				eOn.parentNode.setAttribute( 'disabled', bDisabled );
			}else if( eOn.options ){
				for( i = 0 ; i < eOn.options.length ; i++ ){
					if( eOn.options[i].value == sValue ){
						eOn.options[i].selected = true;
					}
				}
				eOn.disabled = bDisabled;
				eOn.parentNode.setAttribute( 'disabled', bDisabled );
				eOn.onchange();
			}else{
				aeOn = eOn.getElementsByTagName( 'input' );
				for( i = 0 ; i < aeOn.length ; i++ ){
					if( aeOn[i].value == sValue ){
						aeOn[i].checked = true;
						aeOn[i].onclick();
					}
					aeOn[i].disabled = bDisabled;
					aeOn[i].parentNode.setAttribute( 'disabled', bDisabled );
				}
			}
		}
	}
	for( i = 0 ; i < to_hControl.Input.Groups.length ; i++ ){
		to_hControl.Input.Groups[i].disabled = bDisabled;
		to_hControl.Input.Groups[i].parentNode.setAttribute( 'disabled', bDisabled );
		for( ii = 0, j = 0 ; ii < to_hControl.Input.Groups[i].aeDepended.length ; ii++ ){
			if( to_hControl.Input.Groups[i].aeDepended[ii].checked ){
				j++;
			}
		}
		to_hControl.Input.Groups[i].checked = false;
		cmnRemove_class( to_hControl.Input.Groups[i].parentNode, 'partly' );
		if( j ){
			to_hControl.Input.Groups[i].checked = true;
			if( j < ii ){
				cmnSet_class( to_hControl.Input.Groups[i].parentNode, 'partly' );
			}
		}
	}
	if( to_hControl.Button.Delete_profile ){
		to_hControl.Button.Delete_profile.disabled = bDisabled;
	}
	if( to_hControl.Input.Rename_profile ){
		to_hControl.Input.Rename_profile.value = document.getElementById( oTypograph_options.sCurrent_profile_name ).innerHTML;
		to_hControl.Input.Rename_profile.disabled = bDisabled;
	}
}

function toInit_Typograph_options_inputs(){
	var eOn, aeOn, aeOn_children, aeLI, sValue, i, ii, j = 0;

	aeOn = document.getElementsByTagName( 'legend' );
	to_hControl.Input.Groups = new Array();
	for( i = 0 ; i < aeOn.length ; i++ ){
		aeOn_children = aeOn[i].getElementsByTagName( 'input' );
		if( aeOn_children.length ){
			if( !oTypograph_options.Names[ aeOn_children[0].id.substr( 3 ) ] ){
				to_hControl.Input.Groups[j] = aeOn_children[0];
				to_hControl.Input.Groups[j].onclick = toGrouped_checkbox;
				to_hControl.Input.Groups[j].aeDepended = new Array();
				aeOn_children = aeOn[i].parentNode.getElementsByTagName( 'input' );
				for( ii = 0 ; ii < aeOn_children.length ; ii++ ){
					if( to_hControl.Input.Groups[j].id != aeOn_children[ii].id && aeOn_children[ii].getAttribute( 'type' ) == 'checkbox' ){
						to_hControl.Input.Groups[j].aeDepended[to_hControl.Input.Groups[j].aeDepended.length] = aeOn_children[ii];
						aeOn_children[ii].eDepended = to_hControl.Input.Groups[j];
					}
				}
				j++;
			}
		}
		aeOn_children = aeOn[i].parentNode.getElementsByTagName( 'ul' );
		for( ii = 0 ; ii < aeOn_children.length ; ii++ ){
			if( cmnMatch_class( aeOn_children[ii], 'switch_view' ) ){
				aeLI = aeOn_children[ii].getElementsByTagName( 'li' )
				aeLI[0].onclick = function(){ cmnRemove_class( this.parentNode.parentNode, 'summary' ); };
				aeLI[1].onclick = function(){ cmnSet_class( this.parentNode.parentNode, 'summary' ); };
			}
		}
	}

	for( var sName in oTypograph_options.Names ){
		eOn = document.getElementById( 'to_' + sName );
		if( eOn ){
			if( eOn.nodeName.toLowerCase() == 'input' ){
				if( eOn.getAttribute( 'type' ) == 'text' ){
					eOn.onblur = toText_change;
				}else{
					eOn.onclick = toCheckbox_change;
				}
			}else if( eOn.nodeName.toLowerCase() == 'textarea' ){
				eOn.onblur = toText_change;
			}else if( eOn.options ){
				eOn.onchange = toSelect_change;
			}else{
				aeOn = eOn.getElementsByTagName( 'input' );
				for( i = 0 ; i < aeOn.length ; i++ ){
					aeOn[i].onclick = toRadio_change;
				}
			}
		}
	}
	return i;
}

function toGrouped_checkbox(){
	for( var i = 0 ; i < this.aeDepended.length ; i++ ){
		if( !this.aeDepended[i].disabled ){
			this.aeDepended[i].checked = this.checked;
		}
	}
	for( i = 0 ; i < this.aeDepended.length ; i++ ){
		this.aeDepended[i].onclick();
	}
}

function toCheckbox_change(){
	var sName = this.getAttribute( 'name' );
	var sValue = this.value != 0 ? this.checked : !this.checked;
	toApply_on_example( this, this.id, sValue );
	oTypograph_options.Set_option( sName, sValue );
	if( this.eDepended ){
		for( var i = 0, j = 0 ; i < this.eDepended.aeDepended.length ; i++ ){
			if( this.eDepended.aeDepended[i].checked ){
				j++;
			}
		}
		this.eDepended.checked = false;
		cmnRemove_class( this.eDepended.parentNode, 'partly' );
		if( j ){
			this.eDepended.checked = true;
			if( j < i ){
				cmnSet_class( this.eDepended.parentNode, 'partly' );
			}
		}
	}
}

function toSelect_change(){
	var sName = this.getAttribute( 'name' )
	for( var i = 0 ; i < this.options.length ; i++ ){
		if( this.options[i].selected ){
			toApply_on_example( this, this.id + '_' + i, true )
			oTypograph_options.Set_option( sName, this.options[i].value )
		}else{
			toApply_on_example( this, this.id + '_' + i, false )
		}
	}
}

function toRadio_change(){
	var sName = this.getAttribute( 'name' )
	toApply_on_example( this, this.id, true, 'to_' + this.getAttribute('name') + '[^\\s]+' )
	oTypograph_options.Set_option( sName, this.value )
}

function toText_change(){
	var sName = this.getAttribute( 'name' )
	if( this.value.match( /[=;]/ ) ){
		this.value = this.value.replace( /[=;]/g, '' )
	}
	oTypograph_options.Set_option( sName, this.value )
}

function toApply_on_example( eOn, sName, bSet, sExtended_remove ){
	if( sExtended_remove ){
		cmnRemove_class( to_hControl.Block.Example_parent, sExtended_remove )
	}
	if( bSet ){
		cmnSet_class( to_hControl.Block.Example_parent, sName )
	}else{
		cmnRemove_class( to_hControl.Block.Example_parent, sName )
	}
}

var bTypograph_options_script_loaded = true;
