/*
// 2005-10-24
// Copyright (c) Art. Lebedev | http://www.artlebedev.ru/
// Author - Vladimir Tokmakov
*/

var hTypograph_options = new Array();

Typograph_Option_create( "entity_type", 1 );
Typograph_Option_create( "quotation_marks_a", "laquo raquo" );
Typograph_Option_create( "quotation_marks_b", "bdquo ldquo" );

Typograph_Option_create( "preserve_original_nobr", false );
Typograph_Option_create( "preserve_original_minus", false );
Typograph_Option_create( "preserve_original_quot", false );
Typograph_Option_create( "preserve_original_nbsp", false );

Typograph_Option_create( "preprocess_language_misprint", true );
Typograph_Option_create( "preprocess_20l", true );
Typograph_Option_create( "preprocess_20U", true );
Typograph_Option_create( "preprocess_l2E20d", true );
Typograph_Option_create( "preprocess_remove_quot_around_nonrussian", true );
Typograph_Option_create( "preprocess_shift_begin_symbols", true );
Typograph_Option_create( "preprocess_shift_end_symbols", true );
Typograph_Option_create( "preprocess_shift_quot", true );
Typograph_Option_create( "preprocess_mdash_en", false );
Typograph_Option_create( "preprocess_word20end", false );
Typograph_Option_create( "preprocess_mdash_en", false );

Typograph_Option_create( "replace_copy", true );
Typograph_Option_create( "replace_plusmn", true );
Typograph_Option_create( "replace_reg", true );
Typograph_Option_create( "replace_trade", true );
Typograph_Option_create( "replace_times", true );
Typograph_Option_create( "replace_double_dash", true );
Typograph_Option_create( "replace_hellip", false );

Typograph_Option_create( "no_tags", false );
Typograph_Option_create( "br", true );
Typograph_Option_create( "br_string", "<br />" );
Typograph_Option_create( "p", true );
Typograph_Option_create( "p_string", "<p>\$text</p>" );
Typograph_Option_create( "no_nobr", false );
Typograph_Option_create( "nobr", true );
Typograph_Option_create( "nobr_phones", true );

Typograph_Option_create( "collapse_20", true );
Typograph_Option_create( "collapse_09", false );
Typograph_Option_create( "collapse_0A", true );

Typograph_Option_create( "symbols_number_for_nobr", 2 );
Typograph_Option_create( "symbols_number_for_nbsp", 2 );

function Typograph_Option_create( sName, Default_value ){
	hTypograph_options[sName] = new Array();
	hTypograph_options[sName].def = Default_value;
}

function Typograph_Get_options( sOptions ){
	var Default, Current;
	for( var sName in hTypograph_options ){
		Default = hTypograph_options[sName].def.toString();
		Current = Default;
		if( sOptions != "" ){
			if( Default == "true" || Default == "false" ){
				if( sOptions.match( Typograph_Make_regular_expression( "(^|;)" + sName + "=" ) ) ){
					Current = ( sOptions.match( Typograph_Make_regular_expression( "(^|;)" + sName + "=(1|true|yes)($|;)" ) ) ) ? "true" : "false";
				}
			}else{
				if( sOptions.match( Typograph_Make_regular_expression( "(^|;)" + sName + "=" ) ) ){
					Current = sOptions.replace( Typograph_Make_regular_expression( "^.*?(^|;)" + sName + "=(.*?)($|;).*$" ), "$2" );
				}
			}
		}
		if( Current == "true" || Current == "false" ){
			Current = ( Current == "true" ) ? true : false;
		}else if( Current.match( /^[\d\.]+$/ ) ){
			Current = Current * 1;
		}
		hTypograph_options[sName].cur = Current;
	}
}

function Typograph_options(){
	var sCookie_options = "expires=Mon, 11-Jan-10 00:00:00 GMT;path=/;"

	var oThis = this;

	this.sPrefix_profile_name = "profile_";
	this.sDefault_profile_name = this.sPrefix_profile_name + "0";
	this.sCurrent_profile_name = "";

	this.Names = new Array();
	var this_values = new Array();
	if( hTypograph_options ){
		var i = 0;
		for( var sName in hTypograph_options ){
			this.Names[sName] = true;
			this_values[sName] = new Array();
			this_values[sName].def = hTypograph_options[sName].def;
			this_values[sName].num = i;
			i++;
		}
	}

	get_option_values();

	this.Set_current_profile = function( sName ){
		oThis.sCurrent_profile_name = sName;
		document.cookie = "current_profile=" + sName + ";" + sCookie_options;
		oThis.refresh();
	}

	this.Set_option = function( sName, sValue ){
		if( this_values[sName].cur != sValue.toString() ){
			this_values[sName].cur = sValue;
			var sCurrent_profile_value = unescape( cmnPairs_string_get_value( document.cookie, oThis.sCurrent_profile_name ) );
			sCurrent_profile_value = cmnPairs_string_set_value( sCurrent_profile_value, "t" + this_values[sName].num, sValue );
			document.cookie = oThis.sCurrent_profile_name + "=" + escape( sCurrent_profile_value ) + ";" + sCookie_options;
		}
	}

	this.Get_option = function( sName ){
		return this_values[sName].cur;
	}

	this.Rename_current_profile = function( sValue ){
		sValue = sValue.replace( /,/g, '' );
		if( sValue, oThis.sCurrent_profile_name == oThis.sDefault_profile_name ){
			return false;
		}else{
			var asProfile = oThis.Get_profiles();
			var ii = asProfile.length;
			for( var i = 1 ; i < asProfile.length ; i++ ){
				if( oThis.sCurrent_profile_name == oThis.sPrefix_profile_name + i ){
					asProfile[i] = sValue;
				}
			}
			document.cookie = "profiles=" + escape( asProfile.join() ) + ";" + sCookie_options;
			return true;
		}
	}

	this.Remove_current_profile = function( sName ){
		if( oThis.sCurrent_profile_name == oThis.sDefault_profile_name ){
			return false;
		}else{
			var sProfile_name, asProfile = oThis.Get_profiles();
			var ii = asProfile.length - 1;
			var iMove = 0;
			for( var i = 1 ; i < ii ; i++ ){
				sProfile_name = oThis.sPrefix_profile_name + i;
				if( !iMove && oThis.sCurrent_profile_name == sProfile_name ){
					iMove = i;
				}
				if( iMove ){
					document.cookie = sProfile_name + "=" + cmnPairs_string_get_value( document.cookie, oThis.sPrefix_profile_name + ( i + 1 ) ) + ";" + sCookie_options;
				}
			}
			if( !iMove ) iMove = ii;
			var sProfiles = asProfile[0];
			for( i = 1 ; i < asProfile.length ; i++ ){
				if( i != iMove ){
					sProfiles += "," + asProfile[i]
				}
			}
			document.cookie = "profiles=" + escape( sProfiles ) + ";" + sCookie_options;
			oThis.Set_current_profile( oThis.sDefault_profile_name );
			get_option_values();
			return true;
		}
	}

	this.Clone_current_profile = function( sName ){
		var asProfile = oThis.Get_profiles();
		var sProfile_name = oThis.sPrefix_profile_name + asProfile.length;
		asProfile[asProfile.length] = sName;
		document.cookie = sProfile_name + "=" + cmnPairs_string_get_value( document.cookie, oThis.sCurrent_profile_name ) + ";" + sCookie_options;
		document.cookie = "profiles=" + escape( asProfile.join() ) + ";" + sCookie_options;
		oThis.Set_current_profile( sProfile_name );
		return sProfile_name;
	}

	this.Get_profiles = function(){
		var sValue = unescape( cmnPairs_string_get_value( document.cookie, "profiles" ) );
		var asProfile = sValue.split(",");
		return asProfile;
	}

	this.Get_option_values_as_string = function(){
		oThis.refresh();
		var sResult = "";
		for( var sName in this_values ){
			sResult += sName + "=" + this_values[sName].cur + ";";
		}
		return sResult;
	}

	this.refresh = function(){
		get_option_values();
	}

	function get_option_values(){
		var sCurrent_profile_name = unescape( cmnPairs_string_get_value( document.cookie, "current_profile" ) );
		oThis.sCurrent_profile_name = ( sCurrent_profile_name == "" ) ? oThis.sDefault_profile_name : sCurrent_profile_name;
		var sValue, sCurrent_profile_value = unescape( cmnPairs_string_get_value( document.cookie, oThis.sCurrent_profile_name ) );
		var sNew_profile_value = sCurrent_profile_value;
		var bChange_cookie = false;

		for( var sName in this_values ){
			sValue = cmnPairs_string_get_value( sCurrent_profile_value, "t" + this_values[sName].num );
			if( !sValue ){
				sValue = this_values[sName].def;
				sNew_profile_value = cmnPairs_string_set_value( sNew_profile_value, "t" + this_values[sName].num, sValue );
				bChange_cookie = true;
			}
			this_values[sName].cur = sValue;
		}
		if( bChange_cookie ){
			document.cookie = oThis.sCurrent_profile_name + "=" + escape( sNew_profile_value ) + ";" + sCookie_options;
		}
	}

}

var oTypograph_options = new Typograph_options();

var bTypograph_options_script_loaded = true;
