﻿/*
// Copyright (c) Art. Lebedev | http://www.artlebedev.ru/
// Author - Vladimir Tokmakov
// unscientific version ;)
*/
var sTypograph_version = "2006-03-28 12:21";

var t_ptrProcess = "";
var iTypograph_process = 0;
var sNBSP = String.fromCharCode(160);
var sTag_begin_symbol = '¸';
var sTag_end_symbol = '¯';
var asTypotag = "";
var iTypotag_index = "";
var sTypotext = "";
var iSymbols_number_for_nbsp = 3;

var sTag = sTag_begin_symbol + '\\d+' + sTag_end_symbol;
var sOpen_tag = sTag;
var sClose_tag = sTag;

var sEntity_begin_symbol = '¸¯';
var sEntity_end_symbol = '¯¸';
var sEntity = sEntity_begin_symbol + '\\w+' + sEntity_end_symbol;

var sSentence_begin_symbols = '¡¿';
var sWord_begin_symbols = '\\(\\[\\{';
var sWord_all_begin_symbols = sWord_begin_symbols + '\"';
var sSentence_end_symbols = '\\.\\:\\;\\!\\?…';
var sWord_end_symbols = '\\)\\]\\}\\,' + sSentence_end_symbols;
var sWord_all_end_symbols = sWord_end_symbols + '\"';
var sZero_symbols = '©ª®°¹²³´¶™';
var sDigits = '[#\\d\\.\\,\\+\\-±−]*?[\\d¼½¾]+';
var sRome_digits = '[IXCMVLD]*\\-?[IXCMVLD]+(?![ABEFGHJKNOPQRSTUWYZ])';
var sABC_ru = 'а-яіїє';
var sABC_RU = 'А-ЯІЇЄ';
var sABC_Ru = sABC_ru + sABC_RU;
var sABC_en = 'a-z';
var sABC_EN = 'A-Z';
var sABC_En = sABC_en + sABC_EN;
var sABC = sABC_Ru + sABC_En;
var sWord_symbols = sABC + '\\-_';
var sSingle_quotation_mark = '[\x92\x27‘’′]';
var sDouble_quotation_mark = '[\"″«»“”„ȞȜȝ]';
var sException_left = 'бы|б|же|ж|ли|ль|им|их|ей|ее|us';
var sException_right = 'до|по|to';

var sOpen_quotation_mark = sEntity_begin_symbol + '<' + sEntity_end_symbol;
var sClose_quotation_mark = sEntity_begin_symbol + '>' + sEntity_end_symbol;

function Typograph( sText, sOptions ){

	sTypotext = sText;
	iTypotag_index = 0;
	asTypotag = new Array();

	Typograph_Get_options( sOptions );
	iSymbols_number_for_nbsp = hTypograph_options.symbols_number_for_nbsp.cur * 1 + 1;

	Typograph_Init_etities();

//	replace dash
	if( !hTypograph_options.preserve_original_minus.cur ){
		Typograph_Replace( "(\\S)[\x96\x97−–—](\\s)", "$1 -$2", "g" );
		Typograph_Replace( "[\x96\x97−–—]", "-", "g" );
	}

//	cut tags, comments, styles, remove nobr
	Typograph_Cut_tags();

	iTypograph_process = 0;
//	replace gt, lt and &
	Typograph_Replace( "(" + hEntity_special.gt[1] + "|" + hEntity_special.gt[2] + "|" + hEntity_special.gt[3] + ")", hEntity_special.gt[0], "g" );
	Typograph_Replace( "(" + hEntity_special.lt[1] + "|" + hEntity_special.lt[2] + "|" + hEntity_special.lt[3] + ")", hEntity_special.lt[0], "g" );
	Typograph_Replace( "(" + hEntity_special.amp[1] + "|" + hEntity_special.amp[2] + "|" + hEntity_special.amp[3] + ")", hEntity_special.amp.tmp, "g" );

	iTypograph_process = 30;
//	replace nbsp and others
	if( !hTypograph_options.preserve_original_nbsp.cur ){
		Typograph_Replace( sNBSP, "\x20", "g" );
	}
	if( hTypograph_options.collapse_09.cur ){
		Typograph_Replace( "\x09+", "\x20", "g" );
	}
	if( hTypograph_options.collapse_20.cur ){
		Typograph_Replace( "\x20+", "\x20", "g" );
		Typograph_Replace( "((^|\n)(" + sTag + ")*)\x20+", "$1", "g" );
	}

//	replace amp
	Typograph_Replace( "&(?!#\\d+;|\\w+;)", hEntity_special.amp.tmp, "g" );

//	pseudo code replaces
	if( hTypograph_options.replace_plusmn.cur ){
		Typograph_Replace( "(\\+\\-|\\-\\+)", hEntity.plusmn[0], "g" );
	}
	if( hTypograph_options.replace_copy.cur ){
		Typograph_Replace( "\\([cс]\\)", hEntity.copy[0], "gi" );
	}
	if( hTypograph_options.replace_reg.cur ){
		Typograph_Replace( "\\(r\\)", hEntity.reg[0], "gi" );
	}
	if( hTypograph_options.replace_trade.cur ){
		Typograph_Replace( "(\\S)\\(tm\\)", "$1" + hEntity.trade[0], "gi" );
	}
	if( hTypograph_options.replace_hellip.cur ){
		Typograph_Replace( "([^\\.]|^)\\.{3,3}([^\\.]|$)", "$1" + hEntity.hellip[0] + "$2", "g" );
	}else{
		Typograph_Replace( hEntity.hellip[0], "...", "g" );
	}
	if( hTypograph_options.replace_times.cur ){
		Typograph_Replace( "(\\d)(\x20?)([xх])(\x20?)(\\d)", "$1" + hEntity.times[0] + "$5", "g" );
	}
	if( hTypograph_options.replace_double_dash.cur ){
		Typograph_Replace( "(^|[^\-])--([^\-]|$)", "$1-$2", "g" );
	}

	if( !hTypograph_options.preserve_original_quot.cur ){
		Typograph_Replace( sSingle_quotation_mark, "'", "g" );
		Typograph_Replace( sDouble_quotation_mark, "\"", "g" );
	}

	iTypograph_process = 40;
//	place apostrophe
	Typograph_Replace( "([" + sABC + "])(')([" + sABC + "])", "$1" + hEntity.rsquo.tmp + "$3", "g" );
	Typograph_Replace( "(^[^']+)(')([" + sWord_all_end_symbols + "\\s]+)", "$1" + hEntity.rsquo.tmp + "$3", "g" );

//	place mdash
	Typograph_Replace( "(\\S)\x20(" + sTag + ")*-((" + sTag + ")*\\s+\\S)", "$1$2" + hEntity.nbsp.tmp + hEntity.mdash.tmp + "\x20$3", "g" );
	Typograph_Replace( "((^|\n)(" + sTag + ")*)\x20?-\x20(\\S)", "$1" + hEntity.mdash.tmp + hEntity.nbsp.tmp + "$4", "g" );

//	preprocess
	if( hTypograph_options.preprocess_language_misprint.cur ){
		Typograph_Replace( "(C(?=[" + sABC_Ru + "])|([" + sABC_Ru + "])C)", "$2С", "g" );
		Typograph_Replace( "(c(?=[" + sABC_Ru + "])|([" + sABC_Ru + "])c)", "$2с", "g" );
		Typograph_Replace( "(С(?=[" + sABC_En + "])|([" + sABC_En + "])С)", "$2C", "g" );
		Typograph_Replace( "(с(?=[" + sABC_En + "])|([" + sABC_En + "])с)", "$2c", "g" );
	}
	if( hTypograph_options.preprocess_20l.cur ){
		Typograph_Replace( "(\\d|\x20" + sRome_digits + ")([" + sABC_ru + "]{2})", "$1\x20$2", "g" );
	}
	if( hTypograph_options.preprocess_shift_begin_symbols.cur ){
		Typograph_Replace( "([" + sWord_begin_symbols + "])\x20+", "$1", "g" );
	}
	if( hTypograph_options.preprocess_shift_quot.cur ){
		Typograph_Replace( "\x20\"\x20+([" + sABC_RU + sABC_EN + "])", "\x20\"$1", "g" );
		Typograph_Replace( "(\"[" + sABC_RU + sABC_EN + "][^\"]+)\x20\"([" + sWord_end_symbols + "\x20])", "$1\"$2", "g" );
	}
	if( hTypograph_options.preprocess_shift_end_symbols.cur ){
		Typograph_Replace( "\x20+([" + sWord_end_symbols + "])", "$1", "g" );
	}
	
	if( hTypograph_options.preprocess_20U.cur ){
		Typograph_Replace_cyclic( "([" + sSentence_end_symbols + "])([" + sABC_RU + "]|[" + sABC_ru + "]{1," + iSymbols_number_for_nbsp + "}[" + sSentence_end_symbols + "])", "$1\x20$2", "g" );
	}
	if( hTypograph_options.preprocess_l2E20d.cur ){
		Typograph_Replace( "([" + sABC_ru + "]\\.)(\\d)", "$1\x20$2", "g" );
	}
	if( hTypograph_options.preprocess_remove_quot_around_nonrussian.cur ){
//		Typograph_Replace( "\"([a-zA-Z\\d]([a-zA-Z" + sWord_end_symbols + "\\d\x20\\-]+|" + sEntity + ")+[a-zA-Z\\d])\"", "$1", "g" );
	}

//	place nbsp
	//	Internet Explorer_6.0
	Typograph_Replace( "((Q|W|E|R|T|Y|U|I|O|P|A|S|D|F|G|H|J|K|L|Z|X|C|V|B|N|M)[" + sABC_EN + sABC_en + "]*([" + sZero_symbols + "]+|" + sTag + ")*)\x20(?=([A-Za-z]?" + sDigits + "[A-Za-z]?(?!\x20[" + sABC_RU + sABC_EN + "]{0," + hTypograph_options.symbols_number_for_nbsp.cur + "}[\x20" + sWord_end_symbols + "])|" + sRome_digits + "|[A-Z]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}[" + sZero_symbols + "]{0," + hTypograph_options.symbols_number_for_nbsp.cur + "})[\\s" + sWord_all_end_symbols + "])", "$1&_;", "g" );
	//	OOO_"
	Typograph_Replace( "([" + sABC_RU + sABC_EN + "]{1,5})\x20(?=\"[" + sABC_RU + sABC_EN + "])", "$1" + hEntity.nbsp.tmp, "g" );
	// No_1
	Typograph_Replace( "([№§])\x20*(?=[\\d]|" + sRome_digits + ")", "$1&_;", "g" );
	//	bla_/ bla
	Typograph_Replace( "\x20(\\/|" + hEntity_special.amp.tmp + ")\x20", "&_;$1\x20", "g" );

	//	common nbsp
	Typograph_Replace_cyclic( "(([^\\d]|&_;\\S+|^)(\x20|[\"\(]|" + hEntity.nbsp.tmp + "|" + sTag + ")(?!" + sException_left + ")([" + sWord_symbols + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}|[" + sWord_symbols + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}\\-[" + sWord_symbols + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "})(" + sClose_tag + ")*)\x20(?=[\"" + sWord_symbols + "]|" + sDigits + "|" + sClose_tag + ")", "$1" + hEntity.nbsp.tmp, "g" );

	//	in&nbsp;5_ml
	Typograph_Replace( "(((?:^|\x20|\n)[" + sWord_all_begin_symbols + "]*|" + sTag + "|(?![№§])" + hEntity.nbsp.tmp + ")(\\-?\\d+(?:[\\.\\,]\\d+)?[" + sWord_symbols + "]?|" + sRome_digits + ")(\\-[" + sWord_symbols + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}|\\-\\d+(?:[\\.\\,]\\d+)?)?)\x20(?!(" + sTag + ")*(" + sException_right + "|[" + sWord_all_begin_symbols + "])(\x20|" + hEntity.nbsp.tmp + "))", "$1" + hEntity.nbsp.tmp, "gi" );
	//	5_000_000
	Typograph_Replace( "(\\d(\\)(?=\x20\\d+\\-\\d+\\-\\d+))?|" + sException_right + ")\x20(?=" + sDigits + "|" + sRome_digits + ")", "$1" + hEntity.nbsp.tmp, "gi" );
	Typograph_Replace( "\x20(" + sException_left + ")(" + hEntity.nbsp.tmp + "|[" + sWord_all_end_symbols + "])", hEntity.nbsp.tmp + "$1$2", "gi" );

	// F._M._Lastname - fix me	
	Typograph_Replace_cyclic( "(\x20(?![^\\-\\s]+" + hEntity.nbsp.tmp + ")\\S+" + hEntity.nbsp.tmp + "|\x20)([" + sABC_RU + "]\\.)\x20(?=[" + sABC_RU + "])", "$1$2" + hEntity.nbsp.tmp, "g" );
	Typograph_Replace( "((\x20|\x20[" + sABC_RU + sABC_ru + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}\\-[" + sABC_ru + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}" + hEntity.nbsp.tmp + ")[" + sABC_RU + "][" + sABC_ru + "]+)\x20(?=[" + sABC_RU + "]\\.)", "$1" + hEntity.nbsp.tmp, "g" );
	Typograph_Replace( "(\x20[" + sABC_RU + "]\\." + hEntity.nbsp.tmp + "[" + sABC_RU + "]\\.)\x20", "$1" + hEntity.nbsp.tmp, "g" );

	Typograph_Replace_cyclic( "(\x20(?![^\\-\\s]+" + hEntity.nbsp.tmp + ")\\S+" + hEntity.nbsp.tmp + "|\x20)([" + sABC_EN + "]\\.)\x20(?=[" + sABC_EN + "])", "$1$2" + hEntity.nbsp.tmp, "g" );
	Typograph_Replace( "((\x20|\x20[" + sABC_EN + sABC_en + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}\\-[" + sABC_en + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}" + hEntity.nbsp.tmp + ")[" + sABC_EN + "][" + sABC_en + "]+)\x20(?=[" + sABC_EN + "]\\.)", "$1" + hEntity.nbsp.tmp, "g" );
	Typograph_Replace( "(\x20[" + sABC_EN + "]\\." + hEntity.nbsp.tmp + "[" + sABC_EN + "]\\.)\x20", "$1" + hEntity.nbsp.tmp, "g" );

	//	others
	Typograph_Replace( "(\\.|[^" + sWord_all_end_symbols + "])\x20([" + sABC_ru + sABC_en + "]{1," + iSymbols_number_for_nbsp + "}|(\\-?\\d+(?:[\\.\\,]\\d+)?|" + sRome_digits + ")[" + sWord_symbols + "]{0," + hTypograph_options.symbols_number_for_nbsp.cur + "})(\\s*\\n|(" + sClose_tag + "\\s*\\n|[" + sWord_all_end_symbols + "]+(" + sClose_tag + ")*\\s))", "$1" + hEntity.nbsp.tmp + "$2$4", "g" );
	Typograph_Replace( "(^|\x20)(" + sTag + "|[" + sWord_all_begin_symbols + "])*([" + sABC_ru + sABC_en + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}\\.)\x20", "$1$2$3" + hEntity.nbsp.tmp, "g" );
	Typograph_Replace( "([^\\d])(\x20|" + hEntity.nbsp.tmp + ")([" + sABC_ru + "]\\.)\x20([" + sABC_RU + "\\d])", "$1$2$3" + hEntity.nbsp.tmp + "$4", "g" );
	Typograph_Replace( "([^" + sWord_all_end_symbols + "])\x20([" + sWord_symbols + "]{1," + hTypograph_options.symbols_number_for_nbsp.cur + "}([\x20" + sWord_end_symbols + "]))", "$1" + hEntity.nbsp.tmp + "$2", "g" );

	Typograph_Replace( "&_;", hEntity.nbsp.tmp, "g" );

//	open nobr
	Typograph_Open_NOBR();

	iTypograph_process = 50;
//	place mdash in digits range
	Typograph_Replace( "([^\\-\\d]+?)([\\d\\.\\,]*\\d+|" + sRome_digits + ")-([\\d\\.\\,]*\\d+|" + sRome_digits + ")(?![\\-\\d])", "$1$2" + hEntity.mdash.tmp + "$3", "gi" );
//	place minus
	Typograph_Replace( "(\x20|" + hEntity.nbsp.tmp + ")(?:" + sTag + ")*-(\\d)", "$1" + hEntity.minus.tmp + "$2", "gi" );

//	remove spaces around mdash
	if( hTypograph_options.preprocess_mdash_en.cur ){
		Typograph_Replace( "(\\s|" + hEntity.nbsp.tmp + ")*(" + hEntity.mdash.tmp + ")(\\s|" + hEntity.nbsp.tmp + ")*", hEntity.mdash.tmp, "g" );
	}

	iTypograph_process = 90;
//	place quotation
	if( !hTypograph_options.preserve_original_quot.cur ){
		Typograph_Place_quotation( hTypograph_options.quotation_marks_a.cur, hTypograph_options.quotation_marks_b.cur );
	}

//	place prime
	Typograph_Replace( "(\\d\\s*)(')([\x20" + sWord_all_end_symbols + "])", "$1" + hEntity.prime.tmp + "$3", "g" );
	Typograph_Replace( "(\\d\\s*)(\")([\x20" + sWord_all_end_symbols + "])", "$1" + hEntity.Prime.tmp + "$3", "g" );

	Typograph_Replace( "(" + hEntity_special.amp.tmp + "|" + hEntity_special.amp[0] + ")", hEntity_special.amp.entity, "g" );
	Typograph_Replace( "(" + hEntity_special.gt.tmp + "|" + hEntity_special.gt[0] + ")", hEntity_special.gt.entity, "g" );
	Typograph_Replace( "(" + hEntity_special.lt.tmp + "|" + hEntity_special.lt[0] + ")", hEntity_special.lt.entity, "g" );
	for( sName in hEntity ){
		Typograph_Replace( hEntity[sName][0], hEntity[sName].entity, "g" );
		Typograph_Replace( hEntity[sName].tmp, hEntity[sName].entity, "g" );
	}


	Typograph_Replace( "\"", hEntity.quot.entity, "g" );
	Typograph_Replace( "\'", hEntity.rsquo.entity, "g" );

//	return tags
	Typograph_Return_tags();

//	close nobr
	Typograph_Close_NOBR();

	iTypograph_process = 100;
	Typograph_Insert_copyright();

	asTypotag = new Array();

	return sTypotext;
}


function Typograph_Insert_copyright(){
	if( Typograph_Match( "<\\w+[^>]*>" ) ){
		var sCopyright_begin = "<!-- autotypografed by vlalek (";
		var sCopyright_end = ") -->";
		Typograph_Replace( "\\s*" + sCopyright_begin + ".*?" + sCopyright_end, "", "g" );
		sTypotext = sTypotext + "\n\n" + sCopyright_begin + sTypograph_version + sCopyright_end;
	}

}

function Typograph_Cut_tags(){
	if( !hTypograph_options.preserve_original_nobr.cur || hTypograph_options.no_nobr.cur ){
		Typograph_Replace( "<\\/?(nobr|NOBR)[^>]*>", "", "g" );
	}

	var sPattern = "(" + hEntity_special.lt[1] + "\\!--|--" + hEntity_special.gt[1] + ")";
	while( Typograph_Match( sPattern ) ){
		Typograph_Replace_by_function( sPattern, function ( str ){
			asTypotag[iTypotag_index] = str;
			return sTag_begin_symbol + iTypotag_index + sTag_end_symbol;
		} );
		iTypotag_index++;
	}
	sPattern = "(<)(pre|style|script|code|var|samp|PRE|STYLE|SCRIPT|CODE|VAR|SAMP)([^>]*>.*?</\\2>)";
	while( Typograph_Match( sPattern ) ){
		Typograph_Replace_by_function( sPattern, function ( str ){
			asTypotag[iTypotag_index] = str;
			return sTag_begin_symbol + iTypotag_index + sTag_end_symbol;
		} );
		iTypotag_index++;
	}
	sPattern = "(<!--.*?-->|<%.*?%>)";
	while( Typograph_Match( sPattern ) ){
		Typograph_Replace_by_function( sPattern, function ( str ){
			asTypotag[iTypotag_index] = str;
			return sTag_begin_symbol + iTypotag_index + sTag_end_symbol;
		} );
		iTypotag_index++;
	}
	sPattern = "(<[^>]*>)(.?)";
	while( Typograph_Match( sPattern ) ){
		Typograph_Replace_by_function( sPattern, function ( str, p1, p2 ){
			asTypotag[iTypotag_index] = p1;
			if( str.match(/^<br[\s\/][^>]*>[^\s]/) ){
				return sTag_begin_symbol + iTypotag_index + sTag_end_symbol + "\n" + p2;
			}else{
				return sTag_begin_symbol + iTypotag_index + sTag_end_symbol + p2;
			}
		} );
		iTypotag_index++;
	}
}

function Typograph_Return_tags(){
	if( !hTypograph_options.no_tags.cur ){
		Typograph_Replace_by_function( sTag_begin_symbol + "(\\d+)" + sTag_end_symbol, function (str, p1){ return asTypotag[p1] }, "g" );
		Typograph_Replace( "(<sup(\\s[^>]*)?>" + hEntity.reg.entity + "(\\s+|" + hEntity.nbsp.entity + ")?</sup>|" + hEntity.reg.entity + ")", "<sup class=\"reg\">" + hEntity.reg.entity + "</sup>$3", "g" );
	}else{
		Typograph_Replace_by_function( sTag_begin_symbol + "(\\d+)" + sTag_end_symbol, function (str, p1){ if( asTypotag[p1].match(/^\/(p(re)?|h([1-6]|r)|br|d(iv|e?l)|(u|o)lli|table|t[rdh]|blockquote|address|fieldset|form|noscript|ins|script)$/) ) return "\n"; else return""; }, "g" );
	}
}

function Typograph_Open_NOBR(){
	if( hTypograph_options.nobr.cur && !hTypograph_options.no_tags.cur ){
		asTypotag[iTypotag_index] = "<nobr>";

		//	po-moemu pochemu-to
		Typograph_Replace( "(^|\\s)((" + sEntity + "|[" + sWord_all_begin_symbols + "])*(\\S+" + hEntity.nbsp.tmp + "|" + sTag + ")*([" + sABC_ru + sABC_en + "]{1," + hTypograph_options.symbols_number_for_nobr.cur + "})(" + sTag + ")*\\-\\S)",
			"$1" + sTag_begin_symbol + iTypotag_index + sTag_end_symbol + "$2", "gi" );
		Typograph_Replace( "(^|\\s)((" + sEntity + "|[" + sWord_all_begin_symbols + "])*(\\S+" + hEntity.nbsp.tmp + "|" + sTag + ")*[" + sABC_ru + sABC_en + "]{" + (hTypograph_options.symbols_number_for_nobr.cur + 1) + ",}(" + sTag + ")*\\-(" + sTag + ")*[" + sABC_ru + sABC_en + "]{1," + hTypograph_options.symbols_number_for_nobr.cur + "}(" + sTag + "|[" + sWord_all_end_symbols + "])*)(?=\\s|$)",
			"$1" + sTag_begin_symbol + iTypotag_index + sTag_end_symbol + "$2", "gi" );
		//	digits ranges
		Typograph_Replace( "(^|\\s)([^\\s\\-]*?[\\d\\.\\,]*\\d+|" + sRome_digits + ")(-([\\d\\.\\,]*\\d+|" + sRome_digits + "|[" + sABC_ru + sABC_en + "]{1," + hTypograph_options.symbols_number_for_nobr.cur + "})([" + sWord_all_end_symbols + "]*))",
			"$1" + sTag_begin_symbol + iTypotag_index + sTag_end_symbol + "$2$3", "gi" );
	}
//	open nobr phones
	if( hTypograph_options.nobr_phones.cur && !hTypograph_options.no_tags.cur ){
		iTypotag_index++;
		asTypotag[iTypotag_index] = "<nobr class=\"phone\">";
//		Typograph_Replace( "(\x20)?(\\S*(\\+?\\d+(\x20|" + hEntity.nbsp.tmp + ")?)?((\\(([\\+\\d\x20]|" + hEntity.nbsp.tmp + ")+\\)|\\d+)(\x20|" + hEntity.nbsp.tmp + ")?)\\d+\\-\\d+\\-\\d[\\d]*(" + sTag + ")*(\\s|$))", "$1" + sTag_begin_symbol + iTypotag_index + sTag_end_symbol + "$2", "gi" );
		var sGlobal_code = "(?:\\+?\\d+(?:\\x20|" + hEntity.nbsp.tmp + ")?)";
		var sArea_code = "(?:\\d{3,4})";
		var sCode = sGlobal_code + "?" + sArea_code;
		var sNumber = "(?:\\d{2,3}\\-\\d{2,2}-\\d{2,2}|\\d{3,3}\\-\\d{3,3})";
		Typograph_Replace_by_function( "((?:" + sTag + ")*(?:(?:" + sGlobal_code + "?" + sTag + "\\(" + sCode + "\\)|" + sCode + ")(?:\\x20|" + hEntity.nbsp.tmp + "))?(?:" + sTag + ")*" + sNumber + "(?:" + sTag + ")*(?:\\s|$|[" + sWord_all_end_symbols + "]))",
			function (str, p1){
				return sTag_begin_symbol + iTypotag_index + sTag_end_symbol + p1.replace( /\x20/g, hEntity.nbsp.tmp );
			},
			"gi"
		);
	}
	if( hTypograph_options.nobr.cur && !hTypograph_options.no_tags.cur ){
		iTypotag_index++;
		asTypotag[iTypotag_index] = "<nobr>";
		Typograph_Replace( "(^|\\s)([^\\s\\-]*-\\d[^\\s\\-]+)(?=\\s|$)", "$1" + sTag_begin_symbol + iTypotag_index + sTag_end_symbol + "$2", "gi" );
	}
}

function Typograph_Close_NOBR(){
	if( !hTypograph_options.no_tags.cur ){
		Typograph_Replace_cyclic( "(<nobr[^>]*>(?!<nobr))(<(\\/?\\w+)(\\s+[^>]*)*>)(?![^\\s]*</\\3>)", "$2$1", "g" );
		Typograph_Replace_cyclic( "(<nobr[^>]*>)(<nobr[^>]*>)", "$1", "g" );
		Typograph_Replace( "(<nobr[^>]*>(?:<(\\w+)(?:\\s+[^>]*)*>.*?</\\2>|[^<\\s]+?)+)(<[a-z][^>]*\\/>)?", "$1</nobr>$3", "g" );
		Typograph_Replace_cyclic( "(<nobr[^>]*>)(<(\\w+)(\\s+[^>]*)*>)(\\S*?)(</\\3>)(</nobr>)(\\s|$)", "$2$1$5$7$6$8", "g" );
		//	remove nbsp from nobr and wide nobr
		Typograph_Replace_by_function( "(<nobr[^>]*>)(.*?)(</nobr>)",
			function (str, p1, p2, p3){
				p2 = p2.replace( Typograph_Make_regular_expression( "(" + hEntity.nbsp.entity + "|<\\/?nobr[^>]*>)+", "g" ), "\x20" );
				return ( p2.replace( /<\/?[a-z][^>]*>/gi, "" ).length < 30 ) ? p1 + p2 + p3 : p2;
			},
			"g"
		);
		Typograph_Replace( "<\\/nobr><nobr[^>]*>", "", "g" );
	}
}

function Typograph_Place_quotation( sA, sB ){

	Typograph_Replace_cyclic( "((^|[\\s]|" + hEntity.nbsp.tmp + ")([" + sWord_all_begin_symbols + "]|" + sOpen_tag + ")*)([\"\'])(\\S([^\"\']*?|.*?\x20[\"\']\x20.*?)\\S|[^\"\'\\s])[\"\']((" + sClose_tag + "|[" + sWord_all_end_symbols + "])*($|[\\s]|" + hEntity.nbsp.tmp + "))", "$1" + sOpen_quotation_mark + "$5" + sClose_quotation_mark + "$7", "g" );

	var iOpen_quotation_mark = sOpen_quotation_mark.length;
	var iClose_quotation_mark = sClose_quotation_mark.length;
	var ii, j, iOpen_level = 0;
	var sLQ = String.fromCharCode(145), sRQ = String.fromCharCode(146), sLq = String.fromCharCode(147), sRq = String.fromCharCode(148);
	var i = sTypotext.indexOf( sOpen_quotation_mark );
	while( i >= 0 ){
		iOpen_level++;
		if( iOpen_level % 2 == 1 ){
			sTypotext = sTypotext.substring(0, i) + sLQ + sTypotext.substr(i + iOpen_quotation_mark);
		}else{
			sTypotext = sTypotext.substring(0, i) + sLq + sTypotext.substr(i + iOpen_quotation_mark);
		}
		ii = sTypotext.indexOf( sOpen_quotation_mark, i );
		j = sTypotext.indexOf( sClose_quotation_mark, i );
		while( j >= 0 && ( j < ii || ii < 0 ) ){
			iOpen_level--;
			if( iOpen_level % 2 == 1 ){
				sTypotext = sTypotext.substring(0, j) + sRq + sTypotext.substr(j + iClose_quotation_mark);
			}else{
				sTypotext = sTypotext.substring(0, j) + sRQ + sTypotext.substr(j + iClose_quotation_mark);
			}
			j = sTypotext.indexOf( sClose_quotation_mark, j );
			ii -= iClose_quotation_mark;
			ii++;
		}
		i = ii;
	}
	var asE = sA.split(" ");
	sLQ = hEntity[asE[0]].tmp, sRQ = hEntity[asE[1]].tmp;
	asE = sB.split(" ");
	sLq = hEntity[asE[0]].tmp, sRq = hEntity[asE[1]].tmp;
	Typograph_Replace( "\"(\\S[^\"\x91\x92\x93\x94]*)([\x91\x93])", "$2$1$2", "g" );
	Typograph_Replace( "\x91", sLQ, "g" );
	Typograph_Replace( "\x92", sRQ, "g" );
	Typograph_Replace( "\x93", sLq, "g" );
	Typograph_Replace( "\x94", sRq, "g" );
}

function Typograph_Replace_cyclic( sPattern, sReplace, sOptions ){
	var rReplace_pattern = Typograph_Make_regular_expression( sPattern, sOptions );
	if( sOptions ){
		sOptions = sOptions.replace( /g/, "" );
	}
	var rMatch_pattern = Typograph_Make_regular_expression( sPattern, sOptions );
	var i = 0, iMax = 50000;
	while( sTypotext.match( rMatch_pattern ) && i < iMax ){
		sTypotext = sTypotext.replace( rReplace_pattern, sReplace );
		i++;
	}
	if( i == iMax )
		alert("Typograph_Replace_cyclic - endless loop");
}

function Typograph_Replace_by_function( sPattern, fReplace, sOptions ){
	var rPattern = Typograph_Make_regular_expression( sPattern, sOptions );
	sTypotext = sTypotext.replace( rPattern, fReplace );
}

function Typograph_Replace( sPattern, sReplace, sOptions ){
	var rPattern = Typograph_Make_regular_expression( sPattern, sOptions );
	sTypotext = sTypotext.replace( rPattern, sReplace );
	if( t_ptrProcess ){
		t_ptrProcess();
	}
}

function Typograph_Match( sPattern, sOptions ){
	var rPattern = Typograph_Make_regular_expression( sPattern, sOptions );
	return sTypotext.match( rPattern );
}

function Typograph_Make_regular_expression( sPattern, sOptions ){
	return new RegExp( sPattern, sOptions );
}

function Typograph_Init_etities(){
	for( var sName in hEntity ){
		hEntity[sName].entity = hEntity[sName][hTypograph_options.entity_type.cur];
		hEntity[sName].tmp = sEntity_begin_symbol + sName + sEntity_end_symbol;
		Typograph_Replace( hEntity[sName][1], hEntity[sName][0], "g" );
		Typograph_Replace( hEntity[sName][2], hEntity[sName][0], "g" );
		Typograph_Replace( hEntity[sName][3], hEntity[sName][0], "g" );
	}
	for( sName in hEntity_special ){
		hEntity_special[sName].entity = hEntity_special[sName][hTypograph_options.entity_type.cur];
		hEntity_special[sName].tmp = sEntity_begin_symbol + sName + sEntity_end_symbol;
		Typograph_Replace( hEntity_special[sName][2], hEntity_special[sName][1], "g" );
		Typograph_Replace( hEntity_special[sName][3], hEntity_special[sName][1], "g" );
	}
	if( hTypograph_options.entity_type.cur == 0 ){
		hEntity_special.gt.entity = hEntity_special.gt[hTypograph_options.entity_type.def];
		hEntity_special.lt.entity = hEntity_special.lt[hTypograph_options.entity_type.def];
	}
}

var hEntity_special = new Array();
hEntity_special.amp = new Array("&", "&amp;", "&amp;", "&#38;");
hEntity_special.cedil = new Array("¸", "&cedil;", "&cedil;", "&#184;");
hEntity_special.gt = new Array(">", "&gt;", "&gt;", "&#62;");
hEntity_special.lt = new Array("<", "&lt;", "&lt;", "&#60;");
hEntity_special.macr = new Array("¯", "&macr;", "&macr;", "&#175;");

var hEntity = new Array();
hEntity.Aacute = new Array("Á", "&Aacute;", "&Aacute;", "&#193;");
hEntity.aacute = new Array("á", "&aacute;", "&aacute;", "&#225;");
hEntity.Acirc = new Array("Â", "&Acirc;", "&Acirc;", "&#194;");
hEntity.acirc = new Array("â", "&acirc;", "&acirc;", "&#226;");
hEntity.acute = new Array("´", "&acute;", "&acute;", "&#180;");
hEntity.AElig = new Array("Æ", "&AElig;", "&AElig;", "&#198;");
hEntity.aelig = new Array("æ", "&aelig;", "&aelig;", "&#230;");
hEntity.Agrave = new Array("À", "&Agrave;", "&Agrave;", "&#192;");
hEntity.agrave = new Array("à", "&agrave;", "&agrave;", "&#224;");
hEntity.alefsym = new Array("ℵ", "&alefsym;", "&alefsym;", "&#8501;");
hEntity.Alpha = new Array("Α", "&Alpha;", "&Alpha;", "&#913;");
hEntity.alpha = new Array("α", "&alpha;", "&alpha;", "&#945;");
hEntity.Aring = new Array("Å", "&Aring;", "&Aring;", "&#197;");
hEntity.aring = new Array("å", "&aring;", "&aring;", "&#229;");
hEntity.asymp = new Array("≈", "&asymp;", "&asymp;", "&#8776;");
hEntity.Atilde = new Array("Ã", "&Atilde;", "&Atilde;", "&#195;");
hEntity.atilde = new Array("ã", "&atilde;", "&atilde;", "&#227;");
hEntity.Auml = new Array("Ä", "&Auml;", "&Auml;", "&#196;");
hEntity.auml = new Array("ä", "&auml;", "&auml;", "&#228;");
hEntity.bdquo = new Array("„", "&#132;", "&bdquo;", "&#8222;");
hEntity.Beta = new Array("Β", "&Beta;", "&Beta;", "&#914;");
hEntity.beta = new Array("β", "&beta;", "&beta;", "&#946;");
hEntity.brvbar = new Array("¦", "&brvbar;", "&brvbar;", "&#166;");
hEntity.bull = new Array("•", "&bull;", "&bull;", "&#8226;");
hEntity.cap = new Array("∩", "&cap;", "&cap;", "&#8745;");
hEntity.Ccedil = new Array("Ç", "&Ccedil;", "&Ccedil;", "&#199;");
hEntity.ccedil = new Array("ç", "&ccedil;", "&ccedil;", "&#231;");
hEntity.cent = new Array("¢", "&cent;", "&cent;", "&#162;");
hEntity.Chi = new Array("Χ", "&Chi;", "&Chi;", "&#935;");
hEntity.chi = new Array("χ", "&chi;", "&chi;", "&#967;");
hEntity.circ = new Array("ˆ", "&circ;", "&circ;", "&#710;");
hEntity.clubs = new Array("♣", "&clubs;", "&clubs;", "&#9827;");
hEntity.cong = new Array("≅", "&cong;", "&cong;", "&#8773;");
hEntity.copy = new Array("©", "&copy;", "&copy;", "&#169;");
hEntity.crarr = new Array("↵", "&crarr;", "&crarr;", "&#8629;");
hEntity.curren = new Array("¤", "&curren;", "&curren;", "&#164;");
hEntity.dagger = new Array("†", "&dagger;", "&dagger;", "&#8224;");
hEntity.Dagger = new Array("‡", "&Dagger;", "&Dagger;", "&#8225;");
hEntity.darr = new Array("↓", "&darr;", "&darr;", "&#8595;");
hEntity.dArr = new Array("⇓", "&dArr;", "&dArr;", "&#8659;");
hEntity.deg = new Array("°", "&deg;", "&deg;", "&#176;");
hEntity.Delta = new Array("Δ", "&Delta;", "&Delta;", "&#916;");
hEntity.delta = new Array("δ", "&delta;", "&delta;", "&#948;");
hEntity.diams = new Array("♦", "&diams;", "&diams;", "&#9830;");
hEntity.divide = new Array("÷", "&divide;", "&divide;", "&#247;");
hEntity.Eacute = new Array("É", "&Eacute;", "&Eacute;", "&#201;");
hEntity.eacute = new Array("é", "&eacute;", "&eacute;", "&#233;");
hEntity.Ecirc = new Array("Ê", "&Ecirc;", "&Ecirc;", "&#202;");
hEntity.ecirc = new Array("ê", "&ecirc;", "&ecirc;", "&#234;");
hEntity.Egrave = new Array("È", "&Egrave;", "&Egrave;", "&#200;");
hEntity.egrave = new Array("è", "&egrave;", "&egrave;", "&#232;");
hEntity.empty = new Array("∅", "&empty;", "&empty;", "&#8709;");
hEntity.Epsilon = new Array("Ε", "&Epsilon;", "&Epsilon;", "&#917;");
hEntity.epsilon = new Array("ε", "&epsilon;", "&epsilon;", "&#949;");
hEntity.equiv = new Array("≡", "&equiv;", "&equiv;", "&#8801;");
hEntity.Eta = new Array("Η", "&Eta;", "&Eta;", "&#919;");
hEntity.eta = new Array("η", "&eta;", "&eta;", "&#951;");
hEntity.ETH = new Array("Ð", "&ETH;", "&ETH;", "&#208;");
hEntity.eth = new Array("ð", "&eth;", "&eth;", "&#240;");
hEntity.Euml = new Array("Ë", "&Euml;", "&Euml;", "&#203;");
hEntity.euml = new Array("ë", "&euml;", "&euml;", "&#235;");
hEntity.euro = new Array("€", "&euro;", "&euro;", "&#8364;");
hEntity.fnof = new Array("ƒ", "&fnof;", "&fnof;", "&#402;");
hEntity.frac12 = new Array("½", "&frac12;", "&frac12;", "&#189;");
hEntity.frac14 = new Array("¼", "&frac14;", "&frac14;", "&#188;");
hEntity.frac34 = new Array("¾", "&frac34;", "&frac34;", "&#190;");
hEntity.frasl = new Array("⁄", "&frasl;", "&frasl;", "&#8260;");
hEntity.Gamma = new Array("Γ", "&Gamma;", "&Gamma;", "&#915;");
hEntity.gamma = new Array("γ", "&gamma;", "&gamma;", "&#947;");
hEntity.ge = new Array("≥", "&ge;", "&ge;", "&#8805;");
hEntity.harr = new Array("↔", "&harr;", "&harr;", "&#8596;");
hEntity.hearts = new Array("♥", "&hearts;", "&hearts;", "&#9829;");
hEntity.hellip = new Array("…", "&#133;", "&hellip;", "&#133;");
hEntity.Iacute = new Array("Í", "&Iacute;", "&Iacute;", "&#205;");
hEntity.iacute = new Array("í", "&iacute;", "&iacute;", "&#237;");
hEntity.Icirc = new Array("Î", "&Icirc;", "&Icirc;", "&#206;");
hEntity.icirc = new Array("î", "&icirc;", "&icirc;", "&#238;");
hEntity.iexcl = new Array("¡", "&iexcl;", "&iexcl;", "&#161;");
hEntity.Igrave = new Array("Ì", "&Igrave;", "&Igrave;", "&#204;");
hEntity.igrave = new Array("ì", "&igrave;", "&igrave;", "&#236;");
hEntity.image = new Array("ℑ", "&image;", "&image;", "&#8465;");
hEntity.infin = new Array("∞", "&infin;", "&infin;", "&#8734;");
hEntity.integral = new Array("∫", "&int;", "&int;", "&#8747;");
hEntity.Iota = new Array("Ι", "&Iota;", "&Iota;", "&#921;");
hEntity.iota = new Array("ι", "&iota;", "&iota;", "&#953;");
hEntity.iquest = new Array("¿", "&iquest;", "&iquest;", "&#191;");
hEntity.Iuml = new Array("Ï", "&Iuml;", "&Iuml;", "&#207;");
hEntity.iuml = new Array("ï", "&iuml;", "&iuml;", "&#239;");
hEntity.Kappa = new Array("Κ", "&Kappa;", "&Kappa;", "&#922;");
hEntity.kappa = new Array("κ", "&kappa;", "&kappa;", "&#954;");
hEntity.Lambda = new Array("Λ", "&Lambda;", "&Lambda;", "&#923;");
hEntity.lambda = new Array("λ", "&lambda;", "&lambda;", "&#955;");
hEntity.laquo = new Array("«", "&laquo;", "&laquo;", "&#171;");
hEntity.lArr = new Array("⇐", "&lArr;", "&lArr;", "&#8656;");
hEntity.larr = new Array("←", "&larr;", "&larr;", "&#8592;");
hEntity.lceil = new Array("⌈", "&lceil;", "&lceil;", "&#8968;");
hEntity.ldquo = new Array("“", "&#147;", "&ldquo;", "&#147;");
hEntity.le = new Array("≤", "&le;", "&le;", "&#8804;");
hEntity.lfloor = new Array("⌊", "&lfloor;", "&lfloor;", "&#8970;");
hEntity.lowast = new Array("∗", "&lowast;", "&lowast;", "&#8727;");
hEntity.loz = new Array("◊", "&loz;", "&loz;", "&#9674;");
hEntity.lsaquo = new Array("‹", "&lsaquo;", "&lsaquo;", "&#8249;");
hEntity.lsquo = new Array("‘", "&#145;", "&lsquo;", "&#145;");
hEntity.mdash = new Array("—", "&#151;", "&mdash;", "&#151;");
hEntity.micro = new Array("µ", "&micro;", "&micro;", "&#181;");
hEntity.middot = new Array("·", "&middot;", "&middot;", "&#183;");
hEntity.minus = new Array("−", "&minus;", "&minus;", "&#8722;");
hEntity.Mu = new Array("Μ", "&Mu;", "&Mu;", "&#924;");
hEntity.mu = new Array("μ", "&mu;", "&mu;", "&#956;");
hEntity.nbsp = new Array(sNBSP, "&nbsp;", "&nbsp;", "&#160;");
hEntity.ndash = new Array("–", "&#150;", "&ndash;", "&#150;");
hEntity.ne = new Array("≠", "&ne;", "&ne;", "&#8800;");
hEntity.not = new Array("¬", "&not;", "&not;", "&#172;");
hEntity.notin = new Array("∉", "&notin;", "&notin;", "&#8713;");
hEntity.nsub = new Array("⊄", "&nsub;", "&nsub;", "&#8836;");
hEntity.Ntilde = new Array("Ñ", "&Ntilde;", "&Ntilde;", "&#209;");
hEntity.ntilde = new Array("ñ", "&ntilde;", "&ntilde;", "&#241;");
hEntity.Nu = new Array("Ν", "&Nu;", "&Nu;", "&#925;");
hEntity.nu = new Array("ν", "&nu;", "&nu;", "&#957;");
hEntity.num = new Array("№", "&#8470;", "&#8470;", "&#8470;");
hEntity.Oacute = new Array("Ó", "&Oacute;", "&Oacute;", "&#211;");
hEntity.oacute = new Array("ó", "&oacute;", "&oacute;", "&#243;");
hEntity.Ocirc = new Array("Ô", "&Ocirc;", "&Ocirc;", "&#212;");
hEntity.ocirc = new Array("ô", "&ocirc;", "&ocirc;", "&#244;");
hEntity.OElig = new Array("Œ", "&OElig;", "&OElig;", "&#338;");
hEntity.oelig = new Array("œ", "&oelig;", "&oelig;", "&#339;");
hEntity.Ograve = new Array("Ò", "&Ograve;", "&Ograve;", "&#210;");
hEntity.ograve = new Array("ò", "&ograve;", "&ograve;", "&#242;");
hEntity.oline = new Array("‾", "&oline;", "&oline;", "&#8254;");
hEntity.Omega = new Array("Ω", "&Omega;", "&Omega;", "&#937;");
hEntity.omega = new Array("ω", "&omega;", "&omega;", "&#969;");
hEntity.Omicron = new Array("Ο", "&Omicron;", "&Omicron;", "&#927;");
hEntity.omicron = new Array("ο", "&omicron;", "&omicron;", "&#959;");
hEntity.ordf = new Array("ª", "&ordf;", "&ordf;", "&#170;");
hEntity.ordm = new Array("º", "&ordm;", "&ordm;", "&#186;");
hEntity.Oslash = new Array("Ø", "&Oslash;", "&Oslash;", "&#216;");
hEntity.oslash = new Array("ø", "&oslash;", "&oslash;", "&#248;");
hEntity.Otilde = new Array("Õ", "&Otilde;", "&Otilde;", "&#213;");
hEntity.otilde = new Array("õ", "&otilde;", "&otilde;", "&#245;");
hEntity.otimes = new Array("⊗", "&otimes;", "&otimes;", "&#8855;");
hEntity.Ouml = new Array("Ö", "&Ouml;", "&Ouml;", "&#214;");
hEntity.ouml = new Array("ö", "&ouml;", "&ouml;", "&#246;");
hEntity.para = new Array("¶", "&para;", "&para;", "&#182;");
hEntity.part = new Array("∂", "&part;", "&part;", "&#8706;");
hEntity.permil = new Array("‰", "&permil;", "&permil;", "&#8240;");
hEntity.Phi = new Array("Φ", "&Phi;", "&Phi;", "&#934;");
hEntity.phi = new Array("φ", "&phi;", "&phi;", "&#966;");
hEntity.Pi = new Array("Π", "&Pi;", "&Pi;", "&#928;");
hEntity.pi = new Array("π", "&pi;", "&pi;", "&#960;");
hEntity.piv = new Array("ϖ", "&piv;", "&piv;", "&#982;");
hEntity.plusmn = new Array("±", "&plusmn;", "&plusmn;", "&#177;");
hEntity.pound = new Array("£", "&pound;", "&pound;", "&#163;");
hEntity.prime = new Array("′", "&prime;", "&prime;", "&#8242;");
hEntity.Prime = new Array("″", "&Prime;", "&Prime;", "&#8243;");
hEntity.prod = new Array("∏", "&prod;", "&prod;", "&#8719;");
hEntity.Psi = new Array("Ψ", "&Psi;", "&Psi;", "&#936;");
hEntity.psi = new Array("ψ", "&psi;", "&psi;", "&#968;");
hEntity.quot= new Array("\"", "&quot;", "&quot;", "&#34;");
hEntity.radic = new Array("√", "&radic;", "&radic;", "&#8730;");
hEntity.raquo = new Array("»", "&raquo;", "&raquo;", "&#187;");
hEntity.rarr = new Array("→", "&rarr;", "&rarr;", "&#8594;");
hEntity.rceil = new Array("⌉", "&rceil;", "&rceil;", "&#8969;");
hEntity.rdquo = new Array("”", "&#148;", "&rdquo;", "&#8221;");
hEntity.real = new Array("ℜ", "&real;", "&real;", "&#8476;");
hEntity.reg = new Array("®", "&reg;", "&reg;", "&#174;");
hEntity.rfloor = new Array("⌋", "&rfloor;", "&rfloor;", "&#8971;");
hEntity.Rho = new Array("Ρ", "&Rho;", "&Rho;", "&#929;");
hEntity.rho = new Array("ρ", "&rho;", "&rho;", "&#961;");
hEntity.rsaquo = new Array("›", "&rsaquo;", "&rsaquo;", "&#8250;");
hEntity.rsquo = new Array("’", "&#146;", "&rsquo;", "&#146;");
hEntity.sbquo = new Array("‚", "&sbquo;", "&sbquo;", "&#8218;");
hEntity.Scaron = new Array("Š", "&Scaron;", "&Scaron;", "&#352;");
hEntity.scaron = new Array("š", "&scaron;", "&scaron;", "&#353;");
hEntity.sdot = new Array("⋅", "&sdot;", "&sdot;", "&#8901;");
hEntity.sect = new Array("§", "&sect;", "&sect;", "&#167;");
hEntity.shy = new Array("­", "&shy;", "&shy;", "&#173;");
hEntity.Sigma = new Array("Σ", "&Sigma;", "&Sigma;", "&#931;");
hEntity.sigma = new Array("σ", "&sigma;", "&sigma;", "&#963;");
hEntity.sigmaf = new Array("ς", "&sigmaf;", "&sigmaf;", "&#962;");
hEntity.spades = new Array("♠", "&spades;", "&spades;", "&#9824;");
hEntity.sum = new Array("∑", "&sum;", "&sum;", "&#8721;");
hEntity.sup1 = new Array("¹", "&sup1;", "&sup1;", "&#185;");
hEntity.sup2 = new Array("²", "&sup2;", "&sup2;", "&#178;");
hEntity.sup3 = new Array("³", "&sup3;", "&sup3;", "&#179;");
hEntity.szlig = new Array("ß", "&szlig;", "&szlig;", "&#223;");
hEntity.Tau = new Array("Τ", "&Tau;", "&Tau;", "&#932;");
hEntity.tau = new Array("τ", "&tau;", "&tau;", "&#964;");
hEntity.Theta = new Array("Θ", "&Theta;", "&Theta;", "&#920;");
hEntity.theta = new Array("θ", "&theta;", "&theta;", "&#952;");
hEntity.thetasym = new Array("ϑ", "&thetasym;", "&thetasym;", "&#977;");
hEntity.THORN = new Array("Þ", "&THORN;", "&THORN;", "&#222;");
hEntity.thorn = new Array("þ", "&thorn;", "&thorn;", "&#254;");
hEntity.tilde = new Array("˜", "&tilde;", "&tilde;", "&#732;");
hEntity.times = new Array("×", "&times;", "&times;", "&#215;");
hEntity.trade = new Array("™", "&trade;", "&trade;", "&#8482;");
hEntity.Uacute = new Array("Ú", "&Uacute;", "&Uacute;", "&#218;");
hEntity.uacute = new Array("ú", "&uacute;", "&uacute;", "&#250;");
hEntity.uarr = new Array("↑", "&uarr;", "&uarr;", "&#8593;");
hEntity.uArr = new Array("⇑", "&uArr;", "&uArr;", "&#8657;");
hEntity.Ucirc = new Array("Û", "&Ucirc;", "&Ucirc;", "&#219;");
hEntity.ucirc = new Array("û", "&ucirc;", "&ucirc;", "&#251;");
hEntity.Ugrave = new Array("Ù", "&Ugrave;", "&Ugrave;", "&#217;");
hEntity.ugrave = new Array("ù", "&ugrave;", "&ugrave;", "&#249;");
hEntity.uml = new Array("¨", "&uml;", "&uml;", "&#168;");
hEntity.upsih = new Array("ϒ", "&upsih;", "&upsih;", "&#978;");
hEntity.Upsilon = new Array("Υ", "&Upsilon;", "&Upsilon;", "&#933;");
hEntity.upsilon = new Array("υ", "&upsilon;", "&upsilon;", "&#965;");
hEntity.Uuml = new Array("Ü", "&Uuml;", "&Uuml;", "&#220;");
hEntity.uuml = new Array("ü", "&uuml;", "&uuml;", "&#252;");
hEntity.weierp = new Array("℘", "&weierp;", "&weierp;", "&#8472;");
hEntity.Xi = new Array("Ξ", "&Xi;", "&Xi;", "&#926;");
hEntity.xi = new Array("ξ", "&xi;", "&xi;", "&#958;");
hEntity.Yacute = new Array("Ý", "&Yacute;", "&Yacute;", "&#221;");
hEntity.yacute = new Array("ý", "&yacute;", "&yacute;", "&#253;");
hEntity.yen = new Array("¥", "&yen;", "&yen;", "&#165;");
hEntity.yuml = new Array("ÿ", "&yuml;", "&yuml;", "&#255;");
hEntity.Yuml = new Array("Ÿ", "&Yuml;", "&Yuml;", "&#376;");
hEntity.Zeta = new Array("Ζ", "&Zeta;", "&Zeta;", "&#918;");
hEntity.zeta = new Array("ζ", "&zeta;", "&zeta;", "&#950;");

var bTypograph_script_loaded = true;
