﻿
/*
// 2006-06-01
// Copyright (c) Art. Lebedev | http://www.artlebedev.ru/
// Author - Vladimir Tokmakov
*/

var sNBSP = String.fromCharCode(160);

if( !window.rfr_sBase_path ){
	var rfr_sBase_path = "./";
}

var rfr_sImages_path = rfr_sBase_path + "i/";
var rfr_sScripts_path = rfr_sBase_path + "i/";
var rfr_sStyles_path = rfr_sBase_path + "i/";

var rfr_sEditor_CSS_path = rfr_sStyles_path + "editor.css";
if( !window.rfr_sUser_CSS_path ){
	var rfr_sUser_CSS_path = rfr_sStyles_path + "user.css";
}

var rfr_sTypograph_options_script_path = rfr_sScripts_path + "typograph_options.js";
var rfr_sTypograph_script_path = rfr_sScripts_path + "typograph.js";
var rfr_sHTML_script_path = rfr_sScripts_path + "html.js";
var rfr_sAllow_tab_key_script_path = rfr_sScripts_path + "allow_tab_key.js";

if( !window.rfr_sTemplate_path ){
	var rfr_sTemplate_path = rfr_sScripts_path + "clear_html.xsl";
}

var rfr_sOptions_path = rfr_sBase_path + "options.htm";

var rfr_hLabel = new Array();

function rfr_Make_labels(){

rfr_hLabel.alert_regexp_quantifiers_nongreedy_forms_not_support = rfr_Make_label_by_lang([
	"You navigator is not support the non-greedy forms of regular expression.",
	"You navigator is not support the non-greedy forms of regular expression."
]);

rfr_hLabel.copyrights = rfr_Make_label_by_lang([
	"&copy; 2006 Студия Артемия Лебедева",
	"&copy; 2006 Art. Lebedev"]);
rfr_hLabel.toggle_view_title = "[Ctrl+Alt+V]";
rfr_hLabel.toggle_view_to_editor = rfr_Make_label_by_lang([
	"Редактор",
	"Editor"]);
rfr_hLabel.toggle_view_to_preview = rfr_Make_label_by_lang([
	"Просмотр",
	"Preview"]);
rfr_hLabel.toggle_view_to_source = rfr_Make_label_by_lang([
	"Код",
	"Source"]);
rfr_hLabel.clear_html = rfr_Make_label_by_lang([
	"Очистить HTML [Ctrl+Alt+H]",
	"Clear HTML [Ctrl+Alt+H]"]);
rfr_hLabel.typograph = rfr_Make_label_by_lang([
	"Типографить [Ctrl+Alt+T]",
	"Typograph [Ctrl+Alt+T]"]);
rfr_hLabel.toggle_marking = rfr_Make_label_by_lang([
	"Показать / скрыть разметку [Ctrl+Alt+M]",
	"Toggle marking [Ctrl+Alt+M]"]);
rfr_hLabel.typograph_options = rfr_Make_label_by_lang([
	"Настройка...",
	""]);
rfr_hLabel.typograph_default_option = rfr_Make_label_by_lang([
	"Как в студии",
	"Default"]);
rfr_hLabel.statusbar = rfr_Make_label_by_lang([
	"",
	""]);

}

function rfr_Make_label_by_lang( asValue ){
	switch( cmn_oInformation.sLanguage ){
		case "en": return asValue[1];
		default: return asValue[0];
	}
}

cmnInformation.prototype.bSupport_regexp_quantifiers_nongreedy_forms = null;

cmnInformation.prototype.Check_supported_browser_for_regexp_quantifiers_nongreedy_forms = function(){
	var bResult = true;
	if( this.bIE ){
		if( navigator.appVersion.match(/MSIE\s*([0-4]|5\.[^5-9])/) ){
			bResult = false;
		}
	}
	if( !bResult && !cmnGet_cookie( "Support_regexp_quantifiers_nongreedy_forms" ) ){
		cmnSet_cookie( "Support_regexp_quantifiers_nongreedy_forms", bResult );
		alert(rfr_hLabel.alert_regexp_quantifiers_nongreedy_forms_not_support);
	}
	cmnInformation.prototype.bSupport_regexp_quantifiers_nongreedy_forms = bResult;
	return bResult;
}

function rfr_Make_HTML_for_editor( sText ){
	if( sText ){
		return sText.replace( new RegExp( "(" + sNBSP + "|&nbsp;|&#160;)", "g" ), "<span class=\"rfr_nbsp\" unselectable=\"on\">$1</span>" );
	}
	return sText;
}

function rfr_Make_HTML_for_textarea( sText ){
	if( sText ){
		return sText.replace( new RegExp( sNBSP, "g" ), "&nbsp;" );
	}
	return sText;
}


function Reformator( eTEXTAREA ){
	this.eTEXTAREA = eTEXTAREA;
	this.eDIV = null;
	this.eSource = null;
	this.eEditor = null;
	this.oEditor_document = null;
	this.aeAncestor = new Array();
	this.aeSelected = new Array();
	this.bUpdate_textarea = false;
	this.bUpdated = false;
	this.eStatusbar = null;
	this.eView_tabs = null;
}

Reformator.prototype.Set_update_textarea = function( bUpdate ){
	this.bUpdated = bUpdate;
}
Reformator.prototype.Set_updated = function( bUpdate ){
	this.bUpdate_textarea = bUpdate;
}

Reformator.prototype.create = function(){
	var oThis = this;
	var eTEXTAREA = this.eTEXTAREA;

	var eDIV = document.createElement("DIV");
	eDIV.style.width = this.eTEXTAREA.style.width;
	this.eTEXTAREA.style.width = "100%";
	eDIV.style.height = this.eTEXTAREA.style.height;
	eDIV.unselectable = "on";
	cmnSet_class( eDIV, this.eTEXTAREA.className );
	cmnSet_class( eDIV, "rfrHTML" );
	this.eDIV = eDIV;

	this.eTEXTAREA.parentNode.insertBefore( this.eDIV, this.eTEXTAREA );

	var eTEXTAREA_cloned = eTEXTAREA.cloneNode( false );
	this.eTEXTAREA.parentNode.removeChild( eTEXTAREA );
	this.eTEXTAREA = null;
	eTEXTAREA_cloned.value = eTEXTAREA.value;
	var asEvents = new Array("onblur", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onresize");
	for( var i = 0 ; i < asEvents.length ; i++ ){
		if( asEvents[i].indexOf("on") == 0 ){
			eDIV[asEvents[i]] = eTEXTAREA_cloned[asEvents[i]];
			eTEXTAREA_cloned[asEvents[i]] = function(){} 
		}
	}
	this.eSource = eTEXTAREA_cloned;
	eDIV.appendChild( this.eSource );
	cmnAdd_event( this.eSource, "contextmenu",
		function(e){
			oThis.Set_updated( true );
		}
	);
	
	ecMake_IFRAME( "", "", "<html></html>", eDIV,
		function(){
			oThis.eEditor = eDIV.lastChild;
			oThis.oEditor_document = oThis.eEditor.contentWindow ? oThis.eEditor.contentWindow.document : oThis.eEditor.document;
			var sEditor_CSS_code = '<link rel="stylesheet" type="text/css" href="' + rfr_sEditor_CSS_path + '" />';
			var sUser_CSS_code = '<link rel="stylesheet" type="text/css" href="' + rfr_sUser_CSS_path + '" />';
			oThis.oEditor_document.open();
			var eEditor_window = oThis.oEditor_document;
			if( cmn_oInformation.bGecko ){
				oThis.oEditor_document.write("<html><head></head><body>" + rfr_Make_HTML_for_editor( eTEXTAREA.value ) + "</body></html>");
				oThis.oEditor_document.close();
				oThis.oEditor_document.firstChild.firstChild.innerHTML = sEditor_CSS_code + sUser_CSS_code;
				oThis.oEditor_document.designMode = "on";
			}else{
				oThis.oEditor_document.write("<html><head>" + sEditor_CSS_code + sUser_CSS_code + "</head><body>" + rfr_Make_HTML_for_editor( eTEXTAREA.value ) + "</body></html>");
				if( cmn_oInformation.bIE ){
					oThis.oEditor_document.body.contentEditable = true;
					eEditor_window = oThis.oEditor_document.body;
				}
			}
			oThis.oEditor_document.close();

			cmnAdd_event( eEditor_window, "focus", function(){
				oReformator_toolbar.oReformator = oThis;
				if( oReformator_toolbar.oStyle ){ cmnRemove_class( oReformator_toolbar.oStyle.eDIV.firstChild, "disabled" ); }
			} );

			oThis.eView_tabs = document.createElement( "DIV" );
			cmnSet_class( oThis.eView_tabs, "bottom_tabs" );
			var eTab = document.createElement( "SPAN" );
			eTab.unselectable = true;
			eTab.setAttribute( "title", rfr_hLabel.toggle_view_title );
			if( oThis.oEditor_document.designMode || oThis.oEditor_document.body.contentEditable ){
				eTab.innerHTML = '<b>' + rfr_hLabel.toggle_view_to_editor + '</b><input type="checkbox" title="' + rfr_hLabel.toggle_marking + '" />';
			}else{
				eTab.innerHTML = '<b>' + rfr_hLabel.toggle_view_to_preview + '</b><input type="checkbox" title="' + rfr_hLabel.toggle_marking + '" />';
			}
			eTab.firstChild.unselectable = true;
			eTab.lastChild.onmousedown = function(){ this.parentNode.stop = true; }
			eTab.lastChild.onclick = function(){ oThis.Toggle_marking(); }
			eTab.onclick = function(){ if( !this.stop ){ oThis.Toggle_view( 2 ); } this.stop = false; }
			oThis.eView_tabs.appendChild( eTab );
			var eTab = document.createElement( "SPAN" );
			eTab.unselectable = true;
			eTab.setAttribute( "title", rfr_hLabel.toggle_view_title );
			eTab.innerHTML = '<b>' + rfr_hLabel.toggle_view_to_source + '</b>';
			eTab.firstChild.unselectable = true;
			eTab.onclick = function(){ oThis.Toggle_view( 1 ) }
			oThis.eView_tabs.appendChild( eTab );
			eDIV.appendChild( oThis.eView_tabs );

			if( ( oThis.oEditor_document.designMode && oThis.oEditor_document.designMode != 'off' ) || oThis.oEditor_document.body.contentEditable ){
				cmnSet_class( oThis.eSource, "hidden" );
				cmnSet_class( oThis.eEditor, "visible" );
				cmnSet_class( oThis.eView_tabs.childNodes[0], "selected" );
				cmnAdd_events( oThis.oEditor_document, ["contextmenu", "subtreemodified"],
					function(e){
						oThis.Set_update_textarea( true );
						oThis.Set_updated( true );
					}
				);
				cmnAdd_event( oThis.oEditor_document, "mouseup",
					function(e){
						oThis.store_selection();
						oThis.process_event( cmn_oInformation.bIE ? oThis.eEditor.contentWindow.event : e );
					}
				);
				cmnAdd_event( oThis.oEditor_document, "keyup",
					function(e){
						oThis.store_selection();
						oThis.process_key_event( cmn_oInformation.bIE ? oThis.eEditor.contentWindow.event : e );
					}
				);
			}else{
				cmnSet_class( oThis.eSource, "visible" );
				cmnSet_class( oThis.eEditor, "hidden" );
				cmnSet_class( oThis.eView_tabs.childNodes[1], "selected" );
			}

		}
	);

	var eStatusbar = document.createElement("DIV");
	cmnSet_class( eStatusbar, "statusbar" );
	this.eStatusbar = document.createElement("DIV");
	eStatusbar.appendChild( this.eStatusbar );
	eDIV.appendChild( eStatusbar );
	this.eStatusbar.innerHTML = rfr_hLabel.statusbar;

	atkAllow_tab_key_for( this.eSource );

	if( oThis.eEditor ){
		cmnAdd_event( this.eSource, "keyup",
			function(e){
				oThis.eSource.className += "";
				oThis.process_key_event( cmn_oInformation.bIE ? window.event : e );
			}
		);
	}else{
		cmnAdd_event( this.eSource, "keyup",
			function(e){
				oThis.eSource.className += "";
				oThis.process_key_event_reduced( cmn_oInformation.bIE ? window.event : e );
			}
		);
	}
	cmnAdd_event( this.eSource, "focus",
		function(){
			oReformator_toolbar.oReformator = oThis;
			if( oReformator_toolbar.oStyle ){
				cmnSet_class( oReformator_toolbar.oStyle.eDIV.firstChild, "disabled" );
			}
		}
	);
}

Reformator.prototype.focus = function(){
	if( this.eEditor && this.eEditor.contentWindow && this.eEditor.contentWindow.focus ){
		this.eEditor.contentWindow.focus();
		setTimeout( "rfrUpdate_selection_after_focus()", 0);
	}
}

function rfrUpdate_selection_after_focus(){
	oReformator_toolbar.oReformator.update_selection_depended();
}

Reformator.prototype.process_key_event = function(e){
	if( e.ctrlKey && e.altKey ){
		switch( e.keyCode ){
			case 84: oReformator_toolbar.oReformator.Typograph(); break;
			case 72: oReformator_toolbar.oReformator.Clear_HTML(); break;
			case 86: oReformator_toolbar.oReformator.Toggle_view(); break;
			case 77: oReformator_toolbar.oReformator.Toggle_marking(); break;
			default: oReformator_toolbar.process_key_event(e);
		}
	}else{
		oReformator_toolbar.oReformator.Set_updated( true );
		if( cmnMatch_class( this.eSource, "hidden" ) ){
			oReformator_toolbar.oReformator.Set_update_textarea( true );
		}
	}
	oReformator_toolbar.oReformator.update_selection_depended();
}

Reformator.prototype.process_key_event_reduced = function(e){
	if( e.ctrlKey && e.altKey ){
		switch( e.keyCode ){
			case 84: oReformator_toolbar.oReformator.Typograph(); break;
		}
	}else{
		oReformator_toolbar.oReformator.Set_updated( true );
	}
}

Reformator.prototype.process_event = function(e){
	if( !e.ctrlKey && !e.altKey ){
		oReformator_toolbar.oReformator.update_selection_depended();
	}
}

Reformator.prototype.update_selection_depended = function(){
	var abOptions = new Array();
	var aeParent = oReformator_toolbar.oReformator.get_ancestors();
	if( oReformator_toolbar.oReformator.eEditor.eSelected ){ cmnRemove_class( oReformator_toolbar.oReformator.eEditor.eSelected, 'rfr_selected' ); }
	if( aeParent[0] ){
		oReformator_toolbar.oReformator.eEditor.eSelected = aeParent[0];
		cmnSet_class( oReformator_toolbar.oReformator.eEditor.eSelected, 'rfr_selected' );
	}
	var aeA = new Array(), sBlock_title = "", sInline_title = "", sSelector_tag, sSelector_id, sSelector, sClass_name, asClass_name, ii;
	for( var i = aeParent.length ; --i >= 0 ; ){
		aeA[i] = document.createElement( "A" );
		aeA[i].element = aeParent[i];
		aeA[i].href = "";
		aeA[i].onclick = function(){
			this.blur();
			oReformator_toolbar.oReformator.select_element( this.element );
			return false;
		}
		sSelector_tag = aeParent[i].tagName.toLowerCase();
		abOptions[sSelector_tag] = 1;
		aeA[i].innerHTML = sSelector_tag;
		if( aeParent[i].id ){
			sSelector_id = "#" + aeParent[i].id;
			abOptions[sSelector_id] = 1;
			abOptions[sSelector_tag + sSelector_id] = 1;
			aeA[i].innerHTML += sSelector_id;
		}
		if( aeParent[i].className ){
			sClass_name = aeParent[i].className.replace( /\s+/, " " ).replace( /(^\x20|\x20$)/, "" );
			asClass_name = sClass_name.split( " " );
			for( ii = 0 ; ii < asClass_name.length ; ii++ ){
				if( asClass_name[ii].indexOf( 'rfr_' ) < 0 ){
					abOptions["." + asClass_name[ii]] = 1;
					abOptions[sSelector_tag + "." + asClass_name[ii]] = 1;
					aeA[i].innerHTML += "." + asClass_name[ii];
				}
			}
			if( sSelector_id ){
				abOptions[sSelector_id + "." + asClass_name[ii]] = 1;
				abOptions[sSelector_tag + sSelector_id + "." + asClass_name[ii]] = 1;
			}
		}
	}
	if( this.eStatusbar ){
		this.eStatusbar.innerHTML = "";
		for( var i = aeA.length ; --i >= 0 ; ){
			this.eStatusbar.appendChild( aeA[i] );
			if( i ){
				this.eStatusbar.appendChild( document.createTextNode( ' > ' ) );
			}
		}
	}

	if( oReformator_toolbar.oStyle ){ oReformator_toolbar.oStyle.create_selection( abOptions ); }
}

Reformator.prototype.store_selection = function(){
	if( cmn_oInformation.bIE ){
		var etcSelection = this.get_selection();
		var etcRange = this.create_range( etcSelection );
		if( etcRange.getBookmark ){
			this.eEditor.Bookmark = etcRange.getBookmark();
		}
	}
}

Reformator.prototype.restore_selection = function(){
	if( cmn_oInformation.bIE ){
		var etcSelection = this.get_selection();
		var etcRange = this.create_range( etcSelection );
		if( this.eEditor.Bookmark && etcRange.moveToBookmark( this.eEditor.Bookmark ) ){
			etcRange.select();
		}
	}
}

Reformator.prototype.select_element = function( eWhich ){
	htmlSelect_element( this.eEditor.contentWindow, eWhich );
	this.update_selection_depended();
}

Reformator.prototype.refresh_ancestors = function(){
	this.aeAncestor = htmlGet_ancestors( this.eEditor.contentWindow );
}


Reformator.prototype.get_ancestors = function(){
	this.refresh_ancestors();
	return this.aeAncestor;
}

Reformator.prototype.refresh_selected = function(){
	this.aeSelected = htmlGet_selected( this.eEditor.contentWindow );
}

Reformator.prototype.get_selected = function(){
	this.refresh_selected();
	return this.aeSelected;
}

Reformator.prototype.get_selection = function(){
	return htmlGet_selection( this.eEditor.contentWindow );
}

Reformator.prototype.create_range = function( etcSelection ){
	return htmlCreate_range( this.eEditor.contentWindow, etcSelection );
}

function Reformator_toolbar(){
	this.oReformator = null;
	this.eDIV = null;
	this.oStyle = null;
	this.process_key_event = null;
}

Reformator_toolbar.prototype.create = function(){
	var oThis = this;

	var eDIV = document.createElement("DIV");
	eDIV.unselectable = "on";
	this.eDIV = eDIV;

	if( rfr_hUser_CSS && !location.href.match(/test/) ){
		cmnSet_class( document.getElementsByTagName("HTML")[0], "rfrSidebar_opened" );
		this.oStyle = new rfrStylebar( eDIV ).create();
		this.process_key_event = function(e){
			if( this.oStyle.aiShortcut[e.keyCode] ){
				this.oStyle.aiShortcut[e.keyCode].onclick();
			}
		}
		eDIV = document.createElement("DIV");
		eDIV.unselectable = "on";
	}else{
		this.process_key_event = function(e){}
		cmnSet_class( document.getElementsByTagName("HTML")[0], "rfrSidebar_none" );
	}

	document.body.appendChild( eDIV );
	eDIV.id = "rfrToolbar";
	eDIV.appendChild( document.createElement("DIV") );
	
	if( window.ActiveXObject || window.XSLTProcessor ){
		eDIV.appendChild( rfr_Make_button( rfr_hLabel.clear_html, "", function(){ return oThis.oReformator.Clear_HTML() }, "rfr_bClear_html" ) );
	}

	if( window.bTypograph_script_loaded ){
		eDIV.appendChild( rfr_Make_button( rfr_hLabel.typograph, "", function(){ return oThis.oReformator.Typograph() }, "rfr_bTypograph" ) );
		eDIV.appendChild( document.createElement("SPAN") );
		var eSELECT = document.createElement("SELECT");
		eDIV.appendChild( eSELECT );
		var eOPTION = new Option( rfr_hLabel.typograph_default_option, oTypograph_options.sDefault_profile_name );
		eSELECT.options[0] = eOPTION;
		eSELECT.onclick = function(){
			var eOPTION;
			var asProfile = oTypograph_options.Get_profiles();
			oTypograph_options.refresh();
			if( this.options.length != asProfile.length ){
				for( var i = 1 ; i < asProfile.length; i++ ){
					eOPTION = new Option( asProfile[i], oTypograph_options.sPrefix_profile_name + i );
					this.options[i] = eOPTION;
				}
				this.options.length = i;
			}
			for( var i = 0 ; i < this.options.length; i++ ){
				if( this.options[i].value == oTypograph_options.sCurrent_profile_name ){
					this.options[i].selected = true;
				}
			}
		}
		eSELECT.onclick();
		eSELECT.onchange = function(){
			oTypograph_options.Set_current_profile( this.options[this.selectedIndex].value );
		}
		eDIV.appendChild(
			rfr_Make_button( rfr_hLabel.typograph_options, "",
				function(){
					return cmnPopup( rfr_sOptions_path, "rfr_options_window",
						"width=" + ( document.getElementById("rfrCopyrights") ? document.getElementById("rfrCopyrights").offsetHeight * 50 : 700 )
					);
				}, "rfr_bTypograph_options", rfr_sOptions_path
			)
		);
	}

	if( rfr_hUser_CSS && eDIV != this.eDIV ){
		this.eDIV.appendChild( eDIV );
	}

	return this;
}

function rfrStylebar( eDIV ){
	this.eDIV = eDIV;
	this.aeOption = new Array();
	this.aiShortcut = new Array();
}

rfrStylebar.prototype.create = function(){
	this.eDIV.id = "rfrSidebar";
	document.body.appendChild( this.eDIV );
	var eDIV_style = document.createElement("DIV");
	eDIV_style.unselectable = "on";
	eDIV_style.onmousedown = function(){ return false }
	eDIV_style.id = "rfrStyle_select";
	this.eDIV.appendChild( eDIV_style );

	var eDIV_style_reducer = document.createElement("DIV");
	eDIV_style_reducer.unselectable = "on";
	cmnSet_class( eDIV_style_reducer, "reducer" );
	eDIV_style.appendChild( eDIV_style_reducer );

	eDIV_style.appendChild( document.createElement("DIV") );
	eDIV_style.lastChild.id = "rfrStyle_select_shadow";

	if( rfr_hUser_CSS.block ){
		eDIV_style_reducer.appendChild( this.make_group( rfr_hUser_CSS.block, "block" ) );
	}
	if( rfr_hUser_CSS.inline ){
		eDIV_style_reducer.appendChild( this.make_group( rfr_hUser_CSS.inline, "inline" ) );
	}
	if( rfr_hUser_CSS.both ){
		eDIV_style_reducer.appendChild( this.make_group( rfr_hUser_CSS.both, "class" ) );
	}
	if( rfr_hUser_CSS.table ){
		eDIV_style_reducer.appendChild( this.make_group( rfr_hUser_CSS.table, "table" ) );
	}

	var eDIV_switcher = document.createElement("DIV");
	eDIV_switcher.unselectable = "on";
	eDIV_switcher.id = "rfrSidebar_swither";

	eDIV_switcher.onclick = function(){
		cmnSwitch_class( document.getElementsByTagName("HTML")[0], "rfrSidebar_opened", "rfrSidebar_closed" );
		document.body.className += "";
	}
	//cmnAdd_hover( eDIV_switcher );
	document.body.appendChild( eDIV_switcher );

	var eDIV = document.createElement("DIV");
	eDIV.unselectable = "on";
	eDIV.id = "rfrCopyrights";
	eDIV.innerHTML = rfr_hLabel.copyrights;
	this.eDIV.appendChild( eDIV );

	return this;
}

rfrStylebar.prototype.create_selection = function( hOptions ){
	for( var sName in this.aeOption ){
		if( hOptions[sName] ){
			cmnSet_class( this.aeOption[sName], "selected" );
		}else{
			cmnRemove_class( this.aeOption[sName], "selected" );
		}
	}
}

rfrStylebar.prototype.make_group = function( hOption, sType ){
	var eNew = document.createElement("DIV");
	eNew.unselectable = "on";
	eNew.id = "rfrStyle_select_group_" + sType;
	cmnSet_class( eNew, "group " + sType );

	var eList = document.createElement("UL");
	eList.unselectable = "on";
	cmnSet_class( eList, "list" );
	var sInnerHTML = "";
	var eOption, eDIV, sShortcut;
	for( sName in hOption ){
		eOption = document.createElement("LI");
		eOption.unselectable = "on";
		eOption.setAttribute( "title", sName );
		cmnSet_class( eOption, "option" );
		if( !hOption[sName].title || hOption[sName].title.match( /^\s+$/ ) || hOption[sName].style.match( /float\s*\:\s*left/i ) ){
			hOption[sName].style = hOption[sName].style.replace( /float\s*\:\s*left/i, '' );
			cmnSet_class( eOption, 'float');
		}
		if( cmn_oInformation.bIE ){
			eDIV = document.createElement("<DIV style=\"" + hOption[sName].style.replace( /(url\("?)([^\/][^\)]+\))/g, "$1" + rfr_sImages_path + "$2" ) + "\" />");
		}else{
			eDIV = document.createElement("DIV");
			eDIV.setAttribute( "style", hOption[sName].style.replace( /(url\("?)([^\/][^\)]+\))/g, "$1" + rfr_sImages_path + "$2" ) );
		}
		eDIV.unselectable = "on";
		//cmnAdd_hover( eOption );
		eOption.id = hOption[sName].id;
		eDIV.innerHTML = hOption[sName].title;
		eOption.appendChild( eDIV );
		if( hOption[sName].shortcut_code.length ){
			eDIV.setAttribute( "title", "[Ctrl+Alt+" + String.fromCharCode(hOption[sName].shortcut_code) + "]" );
			this.aiShortcut[hOption[sName].shortcut_code * 1] = eOption;
		}
		this.aeOption[eOption.id] = eOption;
		if( sType == "block" || sType == "table" ){
			eOption.onclick = function(){
				var hSelector = htmlParse_CSS_selector_string( this.getAttribute( "title" ) );
				if( hSelector ){
					oReformator_toolbar.oReformator.Set_update_textarea( true );
					oReformator_toolbar.oReformator.Set_updated( true );
					if( hSelector.tagName == "ul" ){
						oReformator_toolbar.oReformator.Exec_command("insertunorderedlist");
						oReformator_toolbar.oReformator.Clear_HTML();
					}else if( hSelector.tagName == "ol" ){
						oReformator_toolbar.oReformator.Exec_command("insertorderedlist");
						oReformator_toolbar.oReformator.Clear_HTML();
					}else if( hSelector.tagName == "ul li ul" ){
						oReformator_toolbar.oReformator.Exec_command("indent");
						oReformator_toolbar.oReformator.Clear_HTML();
					}else if( hSelector.tagName == "blockquote" ){
						oReformator_toolbar.oReformator.Exec_command( "formatblockquote" );
					}else if( hSelector.tagName == "th" || hSelector.tagName == "td" ){
						oReformator_toolbar.oReformator.Exec_command( "formattablecell", false, hSelector );
					}else{
						if( cmn_oInformation.bIE ){
							var etcSelection = oReformator_toolbar.oReformator.get_selection();
							if( etcSelection.type == "None" ){
								var i = 0;
								while(
									oReformator_toolbar.oReformator.aeAncestor[i]
									&& !htmlIs_block( oReformator_toolbar.oReformator.aeAncestor[i].tagName.toLowerCase() )
								){
									i++;
								}
								oReformator_toolbar.oReformator.select_element( oReformator_toolbar.oReformator.aeAncestor[i] );
							}else if( etcSelection.type == "Control" ){
								oReformator_toolbar.oReformator.select_element( oReformator_toolbar.oReformator.aeAncestor[0] );
							}
						}
						oReformator_toolbar.oReformator.Exec_command( "formatblock", false, hSelector );
						oReformator_toolbar.oReformator.refresh_selected();
						for( var i = 0 ; i < oReformator_toolbar.oReformator.aeSelected.length ; i++ ){
							if(
								oReformator_toolbar.oReformator.aeSelected[i]
								&& oReformator_toolbar.oReformator.aeSelected[i].nodeType == 1
								&& oReformator_toolbar.oReformator.aeSelected[i].tagName.toLowerCase() == hSelector.tagName
							){
								//oReformator_toolbar.oReformator.aeSelected[i].className = "";
								cmnSet_class( oReformator_toolbar.oReformator.aeSelected[i], hSelector.className );
							}
						}
					}
					oReformator_toolbar.oReformator.restore_selection();
					oReformator_toolbar.oReformator.update_selection_depended();
				}
				return false;
			}
		}else if( sType == "inline" ){
			eOption.onclick = function(){
				var etcSelection = oReformator_toolbar.oReformator.get_selection();
				if( etcSelection.type == "Control" ){
					oReformator_toolbar.oReformator.select_element( oReformator_toolbar.oReformator.aeAncestor[0] );
				}else if( etcSelection.isCollapsed ){
					//etcSelection.collapseToStart();
					//etcSelection.extend( oReformator_toolbar.oReformator.aeAncestor[0], 0 );
				}
				var eNew, hSelector = htmlParse_CSS_selector_string( this.getAttribute( "title" ) );
				oReformator_toolbar.oReformator.Set_update_textarea( true );
				oReformator_toolbar.oReformator.Set_updated( true );
				oReformator_toolbar.oReformator.Exec_command( "formatinline", false, hSelector );
				oReformator_toolbar.oReformator.restore_selection();
				oReformator_toolbar.oReformator.update_selection_depended();
				return false;
			}
		}else{
			eOption.onclick = function(){
				var etcSelection = oReformator_toolbar.oReformator.get_selection();
				if( etcSelection.type == "Control" ){
					oReformator_toolbar.oReformator.select_element( oReformator_toolbar.oReformator.aeAncestor[0] );
				}
				oReformator_toolbar.oReformator.Set_update_textarea( true );
				oReformator_toolbar.oReformator.Set_updated( true );
				var hSelector = htmlParse_CSS_selector_string( this.getAttribute( "title" ) );
				oReformator_toolbar.oReformator.refresh_selected();
				cmnSwitch_class( oReformator_toolbar.oReformator.aeAncestor[0], hSelector.className, '' );
				oReformator_toolbar.oReformator.update_selection_depended();
				return false;
			}
		}
		eList.appendChild( eOption );
	}
	eNew.appendChild( eList );

	return eNew;
}

function rfr_Make_button( sTitle, sImage_name, ptrAction, sID, sHREF ){
	var eNew;
	if( sHREF ){
		eNew = document.createElement( "A" );
		eNew.href = sHREF;
	}else{
		eNew = document.createElement( "SPAN" );
	}
	if( sID ){
		eNew.id = sID;
	}
	eNew.className = 'button';
	eNew.unselectable = "on";
	eNew.setAttribute( "title", sTitle );
	eNew.onclick = ptrAction;
	//cmnAdd_button_events( eNew );
	if( sImage_name.match( /\.(gif|jpg|jpeg|png|bmp|ico)$/i ) ){
		eNew.innerHTML = '<img src="' + rfr_sImages_path + sImage_name +'" />';
	}else if( sImage_name ){
		eNew.innerHTML =  sImage_name;
	}else{
		eNew.innerHTML = sTitle.replace( /\s+\[[^\]]+\]/g, "" );
	}
	return eNew;
}

Reformator.prototype.Toggle_view = function( iEditor ){
	if( cmnMatch_class( this.eSource, "hidden" ) && ( !iEditor || iEditor == 1 ) ){
		cmnSet_class( this.eEditor, "hidden", "visible" );
		cmnSet_class( this.eStatusbar, "hidden", "visible" );
		if( this.bUpdate_textarea ){
			this.eSource.value = rfr_Make_HTML_for_textarea( htmlTo_string( this.oEditor_document.body, false, rfr_Clear_class_name_attribute ) );
		}
		cmnSet_class( this.eSource, "visible", "hidden" );
		this.eSource.className += "";
		this.eSource.focus();
		cmnRemove_class( this.eView_tabs.childNodes[0], "selected" );
		this.eView_tabs.childNodes[0].childNodes[1].disabled = true;
		cmnSet_class( this.eView_tabs.childNodes[1], "selected" );
		if( oReformator_toolbar.oStyle ){
			cmnSet_class( oReformator_toolbar.oStyle.eDIV.firstChild, "disabled" );
		}
	}else if( cmnMatch_class( this.eSource, "visible" ) && ( !iEditor || iEditor == 2 ) ){
		cmnSet_class( this.eSource, "hidden", "visible" );
		if( cmn_oInformation.bOpera ){
			this.eEditor.document.body.innerHTML = rfr_Make_HTML_for_editor( this.eSource.value );
		}else{
			this.oEditor_document.body.innerHTML = rfr_Make_HTML_for_editor( this.eSource.value );
		}
		cmnSet_class( this.eEditor, "visible", "hidden" );
		cmnSet_class( this.eStatusbar, "visible", "hidden" );
		this.eEditor.className += "";
		this.focus();
		this.restore_selection();
		cmnSet_class( this.eView_tabs.childNodes[0], "selected" );
		this.eView_tabs.childNodes[0].childNodes[1].disabled = false;
		cmnRemove_class( this.eView_tabs.childNodes[1], "selected" );
		if( oReformator_toolbar.oStyle ){
			cmnRemove_class( oReformator_toolbar.oStyle.eDIV.firstChild, "disabled" );
		}
	}
	this.Set_update_textarea( false );
	return false;
}

Reformator.prototype.Toggle_marking = function(){
	if( !this.eView_tabs.childNodes[0].childNodes[1].disabled ){
		if( this.oEditor_document.body.className == "" ){
			this.oEditor_document.body.className = "marking";
			this.eView_tabs.childNodes[0].childNodes[1].checked = true;
		}else{
			this.oEditor_document.body.className = "";
			this.eView_tabs.childNodes[0].childNodes[1].checked = false;
		}
		this.restore_selection();
	}
	this.eEditor.className += "";
	this.eSource.className += "";
	return false;
}

Reformator.prototype.Clear_HTML = function(){
	var eIFRAME = document.getElementById('XML_IFRAME');
	var sXSLT = cmn_oInformation.bGecko ? eIFRAME.contentDocument : eIFRAME.contentWindow.document.body.innerText;

	if( this.eEditor ){

		if( cmnMatch_class( this.eEditor, "hidden" ) ){
			this.oEditor_document.body.innerHTML = rfr_Make_HTML_for_editor( this.eSource.value );
		}
		var sText = htmlTo_string( this.oEditor_document, true, rfr_Clear_class_name_attribute );
		sText = htmlClear( sText, sXSLT, rfr_Clear_class_name_attribute );
		sText = sText.replace( /^\s+<p>\s*<\/p>\s*\n/, "" );
		this.oEditor_document.body.innerHTML =  rfr_Make_HTML_for_editor( sText );
		this.Set_updated( true );
		if( cmnMatch_class( this.eEditor, "hidden" ) ){
			this.eSource.value = rfr_Make_HTML_for_textarea( htmlTo_string( this.oEditor_document.body, false, rfr_Clear_class_name_attribute ) );
		}else{
			this.Set_update_textarea( true );
		}
		this.eEditor.className += "";
		this.eSource.className += "";

		this.restore_selection();

	}else{
		var sText = htmlClear( this.eSource.value, sXSLT, rfr_Clear_class_name_attribute );
		sText = sText.replace( /^\s+<p>\s*<\/p>\s*\n/, "" );
		this.eSource.value = rfr_Make_HTML_for_textarea( sText );
		this.eSource.className += "";
	}
	return false;
}

Reformator.prototype.Typograph = function(){
	var sOptions = oTypograph_options.Get_option_values_as_string();
	if( this.eEditor ){

		this.Set_updated( true );
		if( cmnMatch_class( this.eEditor, "hidden" ) ){
			var sText = this.eSource.value;
			sText = typograph( sText, sOptions );
			this.eSource.value = sText;
		}else{
			var sText = htmlTo_string( this.oEditor_document.body, false, rfr_Clear_class_name_attribute );
			sText = typograph( sText, sOptions );
			this.Set_update_textarea( true );
		}
		this.oEditor_document.body.innerHTML = rfr_Make_HTML_for_editor( sText );
		this.eEditor.className += "";
		this.eSource.className += "";

		this.restore_selection();

	}else{
		var sText = this.eSource.value;
		// need change sOptions for INPUT;
		sText = typograph( sText, sOptions );
		this.eSource.value = sText;
		this.eSource.className += "";
	}
	function typograph( sText, sOptions ){
		report = "";
		var report_step = 0;
		t_ptrProcess = function(){
			if( report_step != iTypograph_process ){
				report_step = iTypograph_process;
				var dtEnd = new Date();
				report += iTypograph_process + "% - " + ( dtEnd - dtBegin ) * 1 + "\n";
				window.status = iTypograph_process + "%";
			}
		}
		dtBegin = new Date();
		sText = Typograph( sText, sOptions );
		var dtEnd = new Date();
		window.status = dtEnd - dtBegin;
		return sText;
	}
	return false;
}

Reformator.prototype.Exec_command = function( sCommand_ID, UI, param ){
	sCommand_ID = sCommand_ID.toLowerCase();
	if( this.eEditor.eSelected ){ cmnRemove_class( this.eEditor.eSelected, 'rfr_selected' ); }
	switch( sCommand_ID ){
		case "formatblockquote":
			var eFirst_ancestor_cell = this.Get_first_ancestor_by_tag_name( 'blockquote' );
			if( eFirst_ancestor_cell ){
				this.Replace_element_by_null( eFirst_ancestor_cell );
			}else{
				this.oEditor_document.execCommand( "indent", UI, param );
			}
			return false;
		case "formattablecell":
			var sTag_name = param.tagName == "th" ? 'td' : 'th', i = 0;
			var eFirst_ancestor_cell = this.Get_first_ancestor_by_tag_name( 't[dh]' );
			if( eFirst_ancestor_cell ){
				var eCell = this.oEditor_document.createElement( param.tagName );
				eCell.colSpan = eFirst_ancestor_cell.colSpan;
				eCell.rowSpan = eFirst_ancestor_cell.rowSpan;
				eCell.className = eFirst_ancestor_cell.className;
				cmnSwitch_class( eCell, param.className, '' );
				eCell.innerHTML = eFirst_ancestor_cell.innerHTML;
				eFirst_ancestor_cell.parentNode.replaceChild( eCell, eFirst_ancestor_cell );
			}
			return false;
		case "formatinline":
			this.oEditor_document.execCommand( "fontname", UI, "vlalek" );
			htmlReplace_tmp_tag( this.oEditor_document, param );
			return false;
		default:
			if( param ){
				var eFirst_ancestor_cell;
				if( eFirst_ancestor_cell = this.Get_first_ancestor_by_tag_name( param.tagName ) ){
					this.Replace_element_by_null( eFirst_ancestor_cell );
					if( param.tagName.match( /^(table)$/i ) ){
						this.Clear_HTML();
					}
					return false;
				}else if( param.tagName.match( /^(div|address)$/i ) ){
					this.refresh_selected();
					if( this.aeSelected.length ){
						var eDIV = this.oEditor_document.createElement( param.tagName );
						eDIV.className = param.className;
						this.aeSelected[0].parentNode.insertBefore( eDIV, this.aeSelected[0] );
						for( var i = 0 ; i < this.aeSelected.length ; i++ ){
							eDIV.appendChild( this.aeSelected[i] );
						}
						return false;
					}
				}else if( param.tagName.match( /^(dl)$/i ) ){
					param.tagName = 'dd';
				}
				this.oEditor_document.execCommand( sCommand_ID, UI, cmn_oInformation.bIE ? '<' + param.tagName + '>' : param.tagName );
				return false;
			}
			this.oEditor_document.execCommand( sCommand_ID, UI, param );
	}
	return false;
}

Reformator.prototype.Replace_element_by_null = function( eWhich ){
	while( eWhich.childNodes.length ){
		eWhich.parentNode.insertBefore( eWhich.childNodes[0], eWhich );
	}
	eWhich.parentNode.removeChild( eWhich );
}

Reformator.prototype.Get_first_ancestor_by_tag_name = function( sTag_name ){
	var i = 0;
	while( this.aeAncestor[i] ){
		if( this.aeAncestor[i].tagName.match( new RegExp( '^' + sTag_name + '$', 'i' ) ) ){
			return this.aeAncestor[i];
		}
		i++;
	}
	return false;
}

var rfr_hUser_CSS = null;

function rfr_Make_user_CSS_hash( sText ){
    if( sText != "" ){
		rfr_hUser_CSS = new Array();
		var rPattern = new RegExp( "([\\w\\-\\_\\.\\#\\s\\[\\]\\=\\~\\:]*\\S)\\s*\\{([^\\}]*)content\\s*:\\s*([^\\;\\}]+)([^\\}]*)\\}", "gi" ), sType;
		while( sText.match( rPattern ) ){
			sText = sText.replace( rPattern, function( str, p1, p2, p3, p4 ){
				var hSelector = htmlParse_CSS_selector_string( p1 );
				var sSelector = htmlGet_selector_string( hSelector );
				if( p3 ){
					var sTitle =
						( p3.indexOf("\"" + cmn_oInformation.sLanguage + "|") >= 0 )
						? p3.replace( new RegExp( ".*\"" + cmn_oInformation.sLanguage + "\\|([^\"]+)\".*" ), "$1" )
						: p3.replace( new RegExp( ".*\"(?!" + cmn_oInformation.sLanguage + "\\|)([^\"]+)\".*" ), "$1" );
					var sShortcut_code = p3.match( /"shortcut_code\|/) ? p3.replace( /.*"shortcut_code\|([^\"]+)\".*/, "$1" ) : "";
				}
				sType = 'both';
				if( hSelector.tagName != "" ){
					if( hSelector.tagName.match( /^t(able|[dh])$/ ) ){
						sType = 'table';
					}else if( htmlIs_block( hSelector.tagName ) ){
						sType = 'block';
					}else{
						sType = 'inline';
					}
				}
				if( !rfr_hUser_CSS[sType] ){
					rfr_hUser_CSS[sType] = new Array();
				}
				rfr_hUser_CSS[sType][sSelector] = new Array();
				rfr_hUser_CSS[sType][sSelector].id = sSelector;
				rfr_hUser_CSS[sType][sSelector].title = sTitle;
				rfr_hUser_CSS[sType][sSelector].shortcut_code = sShortcut_code;
				rfr_hUser_CSS[sType][sSelector].style = p2 + p4;
				return "";
			});
		}
	}
}

function rfr_Clear_class_name_attribute( sHTML ){
	return sHTML.replace( /<(\w+)(\s+[^>]*?)?\s+class\s*=\s*"([^"]+)"/g, function( str, p1, p2, p3 ){
		p1 = p1.toLowerCase();
		if( !p2 ){ p2 = "" }
		if( rfr_hUser_CSS ){
			var sClass_name = p3.replace( /\s+/g, " " ).replace( /(^\x20|\x20$)/, "" );
			var asClass_name = sClass_name.split( " " )
			sClass_name = ""
			if( rfr_hUser_CSS.both ){
				for( var i = 0 ; i < asClass_name.length ; i++ ){
					if( rfr_hUser_CSS.both["." + asClass_name[i]] ){
						sClass_name += asClass_name[i] + " "
					}
				}
			}
			if( p1.match( /^t(able|[dh])$/ ) ){
				if( rfr_hUser_CSS.table ){
					for( var i = 0 ; i < asClass_name.length ; i++ ){
						if( rfr_hUser_CSS.table[p1 + "." + asClass_name[i]] ){
							sClass_name += asClass_name[i] + " "
						}
					}
				}
			}else if( htmlIs_block( p1 ) ){
				if( rfr_hUser_CSS.block ){
					for( var i = 0 ; i < asClass_name.length ; i++ ){
						if( rfr_hUser_CSS.block[p1 + "." + asClass_name[i]] ){
							sClass_name += asClass_name[i] + " "
						}
					}
				}
			}else if( rfr_hUser_CSS.inline ){
				for( var i = 0 ; i < asClass_name.length ; i++ ){
					if( rfr_hUser_CSS.inline[p1 + "." + asClass_name[i]] ){
						sClass_name += asClass_name[i] + " "
					}
				}
			}
			if( sClass_name ){
				return "<" + p1 + ' class="' + sClass_name.substring( 0, sClass_name.length - 1 ) + '"' + p2
			}else{
				return "<" + p1 + p2
			}
		}else{
			return "<" + p1 + p2
		}
	} )
}

var eFORM;
var oReformator_toolbar;
var aoReformator;

function rfr_Get_CSS_text( oDocument ){
	var sCSS = '', i;
	if( oDocument.styleSheets ){
		for( i = 0 ; i < oDocument.styleSheets.length; i++ ){
			sCSS += rfr_Get_CSS_text_from_stylesheet( oDocument.styleSheets[i] );
		}
	}
	return sCSS;
}

function rfr_Get_CSS_text_from_stylesheet( oCSS ){
	var sCSS = '', i;
	if( oCSS ){
		var sRules_selector = oCSS.cssRules ? 'cssRules' : 'rules';
		if( oCSS.imports ){
			try{ for( i = 0 ; i < oCSS.imports.length; i++ ){ sCSS += rfr_Get_CSS_text_from_stylesheet( oCSS.imports[i] ); } }catch(e){}
		}
		//try{
		for( i = 0 ; i < oCSS[sRules_selector].length; i++ ){
			if( oCSS[sRules_selector][i].selectorText ){
				sCSS += oCSS[sRules_selector][i].selectorText
				+ ( oCSS[sRules_selector][i].style
					? ' {' + oCSS[sRules_selector][i].style.cssText+ ';} '
					: oCSS[sRules_selector][i].cssText );
			}
		}
		//}catch(e){}
	}
	return sCSS;
}

function Init_Reformator(){
	cmnInit_Information();
	rfr_Make_labels();
	var aeTEXTAREA = document.getElementsByTagName("textarea");
	var bHave_Reformator = false;
	for( var i = 0; i < aeTEXTAREA.length; i++ ){
		if( cmnMatch_class( aeTEXTAREA[i], "HTML" ) ){
			eFORM = aeTEXTAREA[i].form;
			bHave_Reformator = true;
			break;
		}
	}

	if( bHave_Reformator ){
		ecLoad_external_script( rfr_sAllow_tab_key_script_path, "bAllow_tab_key_script_loaded" );
		if( cmn_oInformation.Check_supported_browser_for_regexp_quantifiers_nongreedy_forms() ){
			ec_asScript_URL[ec_asScript_URL.length] = '';
			ec_asScript_variable[ec_asScript_variable.length] = 'bUSER_CSS';
			ecMake_IFRAME( "USER_CSS_IFRAME", "", '<html><head><link rel="stylesheet" type="text/css" href="' + rfr_sUser_CSS_path + '" /></head><body onload="top.bUSER_CSS = true"></body></html>' );
			ecLoad_external_script( rfr_sTypograph_script_path, "bTypograph_script_loaded" );
			ecLoad_external_script( rfr_sHTML_script_path, "bHTML_script_loaded" );
			ecLoad_external_script( rfr_sTypograph_options_script_path, "bTypograph_options_script_loaded" );
			ecRun_on_load_external_scripts(
				function(){
					var bHave_Reformator = false;
					var aeTEXTAREA = document.getElementsByTagName("textarea");
					var eIFRAME = ecMake_IFRAME( "XML_IFRAME", rfr_sTemplate_path );

					var sUser_CSS_code = "";
					var eIFRAME = document.getElementById("USER_CSS_IFRAME");

					/*
					if( cmn_oInformation.bGecko ){
						for( var i = 0 ; i < eIFRAME.contentWindow.document.styleSheets[0].cssRules.length; i++ ){
							sUser_CSS_code += eIFRAME.contentWindow.document.styleSheets[0].cssRules[i].cssText + "\n";
						}
					}else if( cmn_oInformation.bIE && eIFRAME.contentWindow ){
						sUser_CSS_code = eIFRAME.contentWindow.document.styleSheets[0].cssText;
					}
					*/
					sUser_CSS_code = rfr_Get_CSS_text( eIFRAME.contentWindow.document );

					rfr_Make_user_CSS_hash( sUser_CSS_code );
					( oReformator_toolbar = new Reformator_toolbar() ).create();

					aoReformator = new Array();

					for( i = 0 ; i < aeTEXTAREA.length ; i++ ){
						if( cmnMatch_class( aeTEXTAREA[i], "HTML" ) ){
							( aoReformator[aoReformator.length] = new Reformator( aeTEXTAREA[i] ) ).create();
						}
					}
					if( i > 0 && oReformator_toolbar ){
						oReformator_toolbar.oReformator = aoReformator[0];
						oReformator_toolbar.oReformator.focus();
					}
				}
			);
			cmnAdd_event( eFORM, "submit",
				function(e){
					for( var i = 0; i < aoReformator.length; i++ ){
						if( aoReformator[i].bUpdate_textarea ){
							aoReformator[i].eSource.value = rfr_Make_HTML_for_textarea( htmlTo_string( aoReformator[i].oEditor_document.body, false, rfr_Clear_class_name_attribute ) );
						}
					}
				}
			);
		}
	}
}

cmnAdd_event( window, "load", Init_Reformator );
