﻿
/*
// 2006-01-15
// Copyright (c) Art. Lebedev | http://www.artlebedev.ru/
// Author - Vladimir Tokmakov
*/

var sNBSP = String.fromCharCode(160)

function htmlReplace_tmp_tag( oDocument, hSelector ){
	if( cmn_oInformation.bIE ){
		var sWhich_tag = "font", sWhich_attribute = "face"
	}else{
		var sWhich_tag = "span", sWhich_attribute = "style"
	}
	var aeOld = oDocument.getElementsByTagName( sWhich_tag )
	var aeActual = new Array()
	for( var i = 0 ; i < aeOld.length ; i++ ){
		if( aeOld[i].parentNode.tagName.toLowerCase() == hSelector.tagName ){
			aeActual[aeActual.length] = aeOld[i].parentNode
		}else if( aeOld[i].getAttribute( sWhich_attribute ).match( /vlalek/ ) ){
			aeActual[aeActual.length] = aeOld[i]
		}
	}
	if( aeActual.length ){
		var spWhich_inner = sWhich_tag + "[^>]*vlalek[^>]*"
		var sOn_tag = hSelector.tagName
		var spOn_inner = hSelector.tagName
		var sOn_inner = hSelector.tagName
		if( hSelector.className ){
			spOn_inner += "\\s+class\\s*=\\s*\"?(?:" + hSelector.className +")?\"?"
			sOn_inner += ' class="' + hSelector.className + '"'
		}
		spOn_inner += "[^>]*"
		var aoStep = new Array(), iStep = aoStep.length
		/* <b><f>...</f></b> = ... */ aoStep[iStep] = new Array()
		aoStep[iStep].RegExp = new RegExp( "<" + spOn_inner + "><" + spWhich_inner + ">([^<]*)</" + sWhich_tag + "></" + sOn_tag + ">", "gi" )
		aoStep[iStep].Result = "$1"

		/* <b>...<f>...</f>...</b> = <b>...</b>...<b>...</b> */ iStep = aoStep.length; aoStep[iStep] = new Array()
		aoStep[iStep].RegExp = new RegExp( "(<" + spOn_inner + ">[^<]*)<" + spWhich_inner + ">([^<]*)</" + sWhich_tag + ">([^<]*</" + sOn_tag + ">)", "gi" )
		aoStep[iStep].Result = "$1</" + sOn_tag + ">$2<" + sOn_inner + ">$3"

		/* <f>...<b>...</b>...</f> = <f>...</f> */ iStep = aoStep.length; aoStep[iStep] = new Array()
		aoStep[iStep].RegExp = new RegExp( "(<" + spWhich_inner + ">[^<]*)<" + spOn_inner + ">([^<]*)</" + sOn_tag + ">([^<]*</" + sWhich_tag + ">)", "gi" )
		aoStep[iStep].Result = "$1$2$3"

		/* <f>...</f><b><f>...</f>...</b> = <f>...</f> */ iStep = aoStep.length; aoStep[iStep] = new Array()
		aoStep[iStep].RegExp = new RegExp( "(<" + spWhich_inner + ">[^<]*)((<(" + spWhich_inner + "|" + spOn_inner + "|/" + sWhich_tag + "|/" + sOn_tag + ")>[^<]*)+)</" + sOn_tag + ">", "gi" )
		aoStep[iStep].Result = function( str, p1, p2 ){ return p1 + p2.replace( /<[^>]*>/g, "" ) + "</" + sWhich_tag + ">" }

		/* <f>...</f> = <b>...</b> */ iStep = aoStep.length; aoStep[iStep] = new Array()
		aoStep[iStep].RegExp = new RegExp( "<" + spWhich_inner + ">", "gi" )
		aoStep[iStep].Result = "<" + sOn_inner + ">"
		iStep = aoStep.length; aoStep[iStep] = new Array()
		aoStep[iStep].RegExp = new RegExp( "</" + sWhich_tag + ">", "gi" )
		aoStep[iStep].Result = "</" + sOn_tag + ">"

		var sHTML, j
		for( i = 0 ; i < aeActual.length ; i++ ){
			if( aeActual[i].parentNode ){
				sHTML = aeActual[i].parentNode.innerHTML
				for( j = 0 ; j < aoStep.length ; j++ ){
					sHTML = sHTML.replace( aoStep[j].RegExp, aoStep[j].Result )
				}
				aeActual[i].parentNode.innerHTML = sHTML
			}
		}
	}
}

function htmlSelect_element( oWindow, eWhich ){
	if( oWindow && eWhich){
		if( cmn_oInformation.bIE ){
			etcRange = oWindow.document.body.createTextRange()
			etcRange.moveToElementText( eWhich )
			etcRange.select( eWhich )
		}else{
			var etcSelection = htmlGet_selection( oWindow )
			etcRange = oWindow.document.createRange()
			etcRange.selectNodeContents( eWhich )
			etcSelection.removeAllRanges( etcRange )
			etcSelection.addRange( etcRange )
		}
	}
}

function htmlGet_selected( oWindow ){
	var etcSelection = htmlGet_selection( oWindow )
	var etcRange = htmlCreate_range( oWindow, etcSelection )
	var eParent = null, i = 0
	var aeSelected = new Array()
	if( cmn_oInformation.bIE ){
		eParent = oWindow.document.body.firstChild
		while( eParent ){
			if( eParent.nodeType == 1){
				etcNewRange = oWindow.document.body.createTextRange()
				etcNewRange.moveToElementText( eParent )
				if( etcRange.inRange(etcNewRange) ){
					aeSelected[i] = eParent
					i++
				}/*else{
					etcNewRange.moveStart( "character", eParent.innerHTML.length )
					if( etcRange.inRange(etcNewRange) ){alert(eParent.tagName+' 2')
						aeSelected[i] = eParent
						i++
					}else{
						etcNewRange.moveEnd( "character", eParent.innerHTML.length * -1 )
						if( etcRange.inRange(etcNewRange) ){alert(eParent.tagName+' 3')
							aeSelected[i] = eParent
							i++
						}
					}
				}*/
			}
			eParent = eParent.nextSibling
		}
	}else{
		eParent = etcRange.commonAncestorContainer
		if(	etcRange.startContainer ){
			eParent = etcRange.startContainer
		}
		while( eParent && ( eParent.nodeType == 3 || ( eParent.nodeType == 1 && !htmlIs_block( eParent.tagName.toLowerCase() ) ) ) ){
			eParent = eParent.parentNode
		}
		aeSelected[i] = eParent
		if(	etcRange.endContainer ){
			eParent = etcRange.endContainer
		}
		while( eParent && ( eParent.nodeType == 3 || ( eParent.nodeType == 1 && !htmlIs_block( eParent.tagName.toLowerCase() ) ) ) ){
			eParent = eParent.parentNode
		}
		while( aeSelected[i] && aeSelected[i] != eParent  ){
			aeSelected[i + 1] = aeSelected[i].nextSibling
			i++
		}
	}
	return aeSelected
}

function htmlGet_ancestors( oWindow ){
	var etcSelection = htmlGet_selection( oWindow )
	var etcRange = htmlCreate_range( oWindow, etcSelection )
	var eParent = null, i = 0
	var aeAncestor = new Array()
	if( cmn_oInformation.bIE ){
		if( etcSelection.type == "Control" ){
			eParent = etcRange.item(0)
		}else{
			eParent = etcRange.parentElement()
		}
	}else{
		eParent = etcRange.commonAncestorContainer
		if(
			!etcRange.collapsed && etcRange.startContainer == etcRange.endContainer
			&& etcRange.startOffset - etcRange.endOffset <= 1 && etcRange.startContainer.hasChildNodes()
		){
			eParent = etcRange.startContainer.childNodes[etcRange.startOffset]
		}
	}
	while( eParent && eParent.nodeType == 3 || eParent.className == "rfr_nbsp" ){
		eParent = eParent.parentNode
	}
	while( eParent && eParent.tagName.toLowerCase() != 'body' ){
		if( eParent.nodeType != 3 ){
			aeAncestor[i] = eParent
			i++
		}
		eParent = eParent.parentNode
	}
	return aeAncestor
}

function htmlCreate_range( oWindow, etcSelection ){
	if( cmn_oInformation.bIE ){
		return etcSelection.createRange()
	}else{
		if( typeof etcSelection != "undefined" ){
			try{
				return etcSelection.getRangeAt(0)
			}catch(e){
				return oWindow.createRange()
			}
		}else{
			return oWindow.createRange()
		}
	}
}

function htmlGet_selection( oWindow ){
	return ( cmn_oInformation.bIE ) ? oWindow.document.selection : oWindow.getSelection()
}

function htmlParse_CSS_selector_string( sSelector ){
	if( sSelector ){
		var hSelector = new Array()
		hSelector["tagName"] = ( sSelector.match( /^\s*\w+/ ) ) ? sSelector.replace( /^\s*([\w\s]+).*$/, "$1" ) : ""
		hSelector["tagName"] = hSelector["tagName"].replace( /\s+$/, "" ).toLowerCase()
		hSelector["id"] = ( sSelector.match( /(\#)([\w])/ ) ) ? sSelector.replace( /^([^\#]*)(\#)([\w\d\-]+).*/g, "$3 " ) : ""
		hSelector["className"] = ( sSelector.match( /(\.)([\w])/ ) ) ? sSelector.replace( /^([^\.]*)(\.)([\w\d\-]+)/g, "$3 " ) : ""
		hSelector["className"] = hSelector["className"].replace( /(^\s+|\s+$)/g, "" )
		return hSelector
	}else{
		return null
	}
}

function htmlGet_selector_string( hSelector ){
	if( hSelector ){
		var sTag_name = hSelector.tagName.toLowerCase().replace( /\s+/g, ' ' ).replace( /(^ | $)/g, '' );
		var sClass_name = hSelector.className.replace( /\s+/g, ' ' ).replace( /(^ | $)/g, '' );
		var sID = hSelector.id.replace( /\s+/g, ' ' );
		return sTag_name + ( sClass_name ? '.' + sClass_name : '' ) + ( sID ? '#' + sID : '' );
	}
}

function htmlTo_string( eIn, bNo_entity, fPostprocess ){
	if( window.oTypograph_options && !bNo_entity ){
		oTypograph_options.refresh();
		var iEntity_type = oTypograph_options.Get_option( "entity_type" );
		var iEntity_special_type = ( iEntity_type != 0 ) ? iEntity_type : 1;
		var sText = htmlInnerHTML_to_string( eIn, iEntity_type, iEntity_special_type  );
		for( var sName in hEntity ){
			sText = sText.replace( new RegExp( hEntity[sName][0] + "(?![^<]*>)", "g" ), hEntity[sName][iEntity_type] );
		}
		sText = sText.replace( /(^\s+|\s+$)/, '' );
	}else{
		sText = htmlInnerHTML_to_string( eIn ).replace( /(^\s+|\s+$)/, '' );
	}
	if( fPostprocess ){
		sText = fPostprocess( sText );
	}
	return sText;
}

function htmlInnerHTML_to_string( eIn, iEntity_type, iEntity_special_type ){
	var aeChild = eIn.childNodes
	var sNode_name = "", sInner_text, sNode_value, sBreak
	var sText = ""
	for( var i = 0 ; i < aeChild.length ; i++ ){
		if( aeChild[i].nodeType == 1 ){
			sNode_name = aeChild[i].nodeName.toLowerCase()
			sInner_text = htmlInnerHTML_to_string( aeChild[i], iEntity_type, iEntity_special_type )
			if( sNode_name == "span" && aeChild[i].className == "rfr_nbsp" ){
				sText += "&nbsp;"
			}else{
				if( sInner_text != "" || sNode_name.match( /^(t[dh]|caption)$/ ) ){
					if( sInner_text == " " || sInner_text == sNBSP ){
						sText += " "
					}else{
						sBreak = htmlIs_block( sNode_name ) ? "\n" : ""
						sText += sBreak + "<" + sNode_name + htmlAttributes_to_string( aeChild[i] ) + ">"
						sText += sInner_text
						sText += "</" + sNode_name + ">"
						sText = sText.replace( /(\s+)(<\/[a-z]+>)/, '$2$1' )
						sText += sBreak
					}
				}else if( sNode_name == "br" || sNode_name == "hr" || sNode_name == "img" ){
					sText += "<" + sNode_name + htmlAttributes_to_string( aeChild[i] ) + " />"
				}
			}
		}else if( aeChild[i].nodeType == 3 && ( !aeChild[i].nodeValue || !aeChild[i].nodeValue.match(/^\n+$/) ) ){
			if( iEntity_type ){
				sNode_value = aeChild[i].nodeValue.replace( /&/g, hEntity_special.amp[iEntity_special_type] ).replace( /</g, hEntity_special.lt[iEntity_special_type] ).replace( />/g, hEntity_special.gt[iEntity_special_type] )
			}else{
				sNode_value = aeChild[i].nodeValue.replace( /&/g, "&amp;" ).replace( /</g, "&lt;" ).replace( />/g, "&gt;" )
			}
			sText += sNode_value
		}
	}
	sText = sText.replace( /<span\s*>(.*?)<\/span>/g, "$1" )
	var rPattern = new RegExp( "<(?!nobr)([\\w\\-]+)(\\s+[^>]+)?>(.*?)</\\1>([\x20]*|&nbsp;)<\\1\\2>", "g" )
	while( sText.match( rPattern ) ){
		sText = sText.replace( rPattern,
			function( str, p1, p2, p3, p4 ){
				if( !htmlIs_block(p1) ){
					if( !p2 ) p2 = ""
					if( !p3 ) p3 = ""
					return "<" + p1 + p2 + ">" + p3 + p4
				}else{
					return str
				}
			}
		)
	}
	return sText.replace( /\n\n+/g, '\n' )
}

function htmlAttributes_to_string( eIn ){
	var aaAttribute = eIn.attributes
	var sText = ""
	for( var i = 0 ; i < aaAttribute.length ; i++ ){
		if(
			aaAttribute[i].nodeValue && aaAttribute[i].nodeValue != "null"
			&& !aaAttribute[i].nodeName.match(/(:|^(hidefocus|contenteditable|disabled|nowrap|tabindex|compact|start)$)/gi)
			&& !( aaAttribute[i].nodeName.match(/^(col|row)span$/gi) && aaAttribute[i].nodeValue == 1 )
			&& !( aaAttribute[i].nodeName.match(/^(value)$/gi) && aaAttribute[i].nodeValue < 2 )
		){
			sText = sText + ' ' + aaAttribute[i].nodeName.toLowerCase() + '="' + aaAttribute[i].nodeValue + '"'
		}
	}
	return sText.replace( /&/g, "&amp;" ).replace( /</g, "&lt;" ).replace( />/g, "&gt;" )
}

function htmlIs_block( sName ){
	return ( sName.length && sName.match( /(^|\s)(p(re)?|h([1-6]|r)|br|d(iv|e?l)|[uod]l|li|d[dt]|table|caption|t([rdh]|head|body|foot)|blockquote|address|fieldset|form|noscript|ins|script)$/) ) ? true : false
}

function htmlClear( sOldHTML, sXSLT, fPostprocess ){
	var sHTML = sOldHTML.replace( /&nbsp;/g, sNBSP )
	var sXML = '<?xml version="1.0"?>\n<html>' + sHTML + '</html>'
	var xmlXML, xmlXSLT
	if( cmn_oInformation.bIE ){
		sXSLT = sXSLT.replace(/(\-|\+)\s</g, "<")
		sXSLT = sXSLT.replace(/<!DOCTYPE\s[^>]*>/, "")
		try{
			xmlXML  = new ActiveXObject("Microsoft.XMLDOM")
			xmlXML.validateOnParse = true
			xmlXML.async = false
			sXML = sXML.replace(/(<\/\w+>)\s+</g, "$1\xa6\xa7\xa8<")
			xmlXML.loadXML(sXML)

			xmlXSLT = new ActiveXObject("Microsoft.XMLDOM")
			xmlXSLT.validateOnParse = true
			xmlXSLT.async = false
			xmlXSLT.loadXML(sXSLT)

			sHTML = xmlXML.transformNode(xmlXSLT)
			sHTML = sHTML.replace(/\xa6\xa7\xa8/g, " ")
		}
		catch(error){
			sHTML = sOldHTML
			alert(error.description)
		}
	}else if( cmn_oInformation.bGecko ){
		try{
			var processor = new XSLTProcessor()
			var dpNew = new DOMParser()
			var xmlXML = dpNew.parseFromString(sXML, "text/xml")
			processor.importStylesheet(sXSLT)
			var xmlNew = processor.transformToDocument(xmlXML)
			sHTML = xmlNew.documentElement.innerHTML
			sHTML = sHTML.replace(/\s*<p>\s*<\/p>\s*/, "")
		}
		catch(error){
			sHTML = sOldHTML
			alert(error.toString())
		}
	}
	if( fPostprocess ){
		sHTML = fPostprocess( sHTML );
	}
	return sHTML.replace( /.*<body(\s+[^>]*)*>(.*?)<\/body>/i, "$2" )
}

var bHTML_script_loaded = true
