﻿<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE xsl:stylesheet [
	<!--=================== Text Elements ====================================-->
	<!ENTITY special.pre "br | span | bdo ">
	<!ENTITY special "&special.pre; | object | img">
	<!ENTITY fontstyle "tt | i | b | big | small">
	<!ENTITY phrase "em | strong | dfn | code | q | samp | kbd | var | cite | abbr | acronym | sub | sup">
	<!ENTITY inline.forms "input | select | textarea | label | button">
	<!-- these can occur at block or inline level -->
	<!ENTITY misc.inline "ins | del | script">
	<!-- these can only occur at block level -->
	<!ENTITY misc "noscript | &misc.inline;">
	<!ENTITY inline "a | &special; | &fontstyle; | &phrase; | &inline.forms;">
	<!-- %Inline; covers inline or "text-level" elements -->
	<!ENTITY Inline "&inline; | nobr">
	<!--================== Block level elements ==============================-->
	<!ENTITY heading "h1 | h2 | h3 | h4 | h5 | h6">
	<!ENTITY lists "ul | ol | dl">
	<!ENTITY blocktext "pre | hr | blockquote | address">
	<!ENTITY block "p | &heading;| div | &lists; | &blocktext; | fieldset | table | map | area">
	<!ENTITY Block "&block; | form | &misc;">

	<!ENTITY inners "li | dt | dd | tr | td | th">
	<!ENTITY outers "table | &lists;">
	<!ENTITY Deprecated "font | big | small | u | s">
	<!ENTITY InlineAndDeprecated "&Deprecated; | &Inline;">
	<!ENTITY Empty "img | br | hr">
]>

<!--
 2006-03-31
 Author - Vladimir Tokmakov
-->

<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
		encoding="UTF-8"
		indent="no"
	/>


	<xsl:template match="/">
		<html>
			<body>
				<xsl:apply-templates select="html" />
				<!--xsl:copy-of select="html/*" /-->
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="html">
		<xsl:apply-templates />
	</xsl:template>


	<xsl:template match="*">
		<xsl:apply-templates />
	</xsl:template>

	<xsl:template match="&Inline;">
		<xsl:variable name="Text">
			<xsl:value-of select="text()" />
			<xsl:value-of select="&InlineAndDeprecated;/text()" />
			<xsl:if test="&Empty;">_</xsl:if>
		</xsl:variable>
		<xsl:if test="string($Text) and normalize-space($Text) != ' '">
			<xsl:choose>
				<xsl:when test="ancestor::*[name() = name(current())]">
					<xsl:copy-of select="@class" />
					<xsl:apply-templates />
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="{name()}">
						<xsl:copy-of select="@class" />
						<xsl:apply-templates select="&InlineAndDeprecated; | text()" />
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:apply-templates select="&Block;" />
	</xsl:template>

	<xsl:template match="i">
		<em>
			<xsl:apply-templates />
		</em>
	</xsl:template>


	<xsl:template match="b">
		<strong>
			<xsl:apply-templates />
		</strong>
	</xsl:template>


	<xsl:template match="nobr">
		<nobr>
			<xsl:copy-of select="@class" />
			<xsl:apply-templates />
		</nobr>
	</xsl:template>


	<xsl:template match="&Block; | table/tbody[tr]">
		<xsl:variable name="Text">
			<xsl:value-of select="text()" />
			<xsl:value-of select="descendant::*/text()" />
			<xsl:if test="&Empty;">_</xsl:if>
		</xsl:variable>
		<xsl:if test="string($Text) and normalize-space($Text) != ' '">
			<xsl:element name="{name()}">
				<xsl:copy-of select="@class" />
				<xsl:apply-templates />
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<xsl:template match="p | &heading;">
		<xsl:variable name="Text">
			<xsl:value-of select="text()" />
			<xsl:value-of select="&InlineAndDeprecated;/text()" />
		</xsl:variable>
		<xsl:if test="string($Text) and normalize-space($Text) != ' '">
			<xsl:element name="{name()}">
				<xsl:copy-of select="@class" />
				<xsl:apply-templates select="&InlineAndDeprecated; | text()" />
			</xsl:element>
		</xsl:if>
		<xsl:apply-templates select="&Block;" />
	</xsl:template>

	<xsl:template match="span | &Deprecated;">
		<xsl:apply-templates />
	</xsl:template>


	<xsl:template match="ul[li] | ol[li]">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@class" />
			<xsl:apply-templates select="li" />
		</xsl:element>
	</xsl:template>


	<xsl:template match="ol/li | ul/li">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@class" />
			<xsl:apply-templates />
			<xsl:apply-templates select="following-sibling::*[name() != 'li' and preceding-sibling::*[name() = name(current())][1] = current()]" />
		</xsl:element>
	</xsl:template>


	<xsl:template match="table[tbody/tr/th | tbody/tr/td | tr/th | tr/td]">
		<table>
			<caption>
				<xsl:apply-templates select="caption/text() | caption/&Inline; | caption/descendant::&Block;/text()" />
			</caption>
			<xsl:choose>
				<xsl:when test="descendant::tr[1][th and not(th/@rowspan &gt; 1 or td)] and not( descendant::tr[2]/th )">
					<!--xsl:variable name="header_rows_count" select="count( descendant::tr[th and not(td) and not( preceding-sibling::tr/td )] )" /-->
					<thead>
						<xsl:apply-templates select="descendant::tr[1]" />
					</thead>
					<tbody>
						<xsl:apply-templates select="descendant::tr[position() &gt; 1]" />
					</tbody>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="thead | tfoot | tbody">
							<xsl:if test="thead">
								<thead>
									<xsl:apply-templates select="thead/tr" />
								</thead>
							</xsl:if>
							<tbody>
								<xsl:apply-templates select="tr | tbody/tr" />
							</tbody>
							<xsl:if test="tfoot">
								<thead>
									<xsl:apply-templates select="tfoot/tr" />
								</thead>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<tbody>
								<xsl:apply-templates select="descendant::tr[position() &gt; 1]" />
							</tbody>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</table>
	</xsl:template>


	<xsl:template match="td[ancestor::table] | th[ancestor::table]">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@colspan[number(.) &gt; 1] | @rowspan[number(.) &gt; 1] | @class" />
			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>


	<xsl:template match="dl[dt or dd]">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@class" />
			<xsl:apply-templates select="dt | dd" />
		</xsl:element>
	</xsl:template>


	<xsl:template match="dl/dt | dl/dd | tr[ancestor::table and( td or th )]">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@class" />
			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>


	<xsl:template match="img">
		<img>
			<xsl:attribute name="src">
				<xsl:choose>
					<xsl:when test="string(@designtimeurl)"><xsl:value-of select="@designtimeurl" /></xsl:when>
					<xsl:otherwise><xsl:value-of select="@src" /></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:copy-of select="@alias | @alt" />
		</img>
	</xsl:template>


	<xsl:template match="a">
		<a>
			<xsl:attribute name="href">
				<xsl:choose>
					<xsl:when test="string(@designtimeurl)"><xsl:value-of select="@designtimeurl" /></xsl:when>
					<xsl:otherwise><xsl:value-of select="@href" /></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:copy-of select="@object-id | @title | @class | @params | @name | @city" />
			<xsl:apply-templates />
		</a>
	</xsl:template>


	<xsl:template match="br | hr">
		<xsl:element name="{name()}" />
	</xsl:template>


</xsl:stylesheet>
