/*
// 2005-03-26
// Copyright (c) Art. Lebedev | http://www.artlebedev.ru/
// Author - Vladimir Tokmakov
*/

cmnAdd_event( window, "load", atkAllow_tab_key_in_text_inputs );

function atkAllow_tab_key_in_text_inputs(){
	var aeText_input = document.getElementsByTagName("TEXTAREA");
	for( var i = 0 ; i < aeText_input.length ; i++ ){
		if( cmnMatch_class( aeText_input[i], "allow_tab_key" )
			&& aeText_input[i].bTab_pressed != false ){
			atkAllow_tab_key_for( aeText_input[i] );
		}
	}
	aeText_input = document.getElementsByTagName("INPUT");
	for( var i = 0 ; i < aeText_input.length ; i++ ){
		if( aeText_input[i].getAttribute("type").toLowerCase() == "text"
			&& cmnMatch_class( aeText_input[i], "allow_tab_key" )
			&& aeText_input[i].bTab_pressed != false ){
			atkAllow_tab_key_for( aeText_input[i] );
		}
	}
}

atk_aeText_input = new Array();

function atkAllow_tab_key_for( eInput ){
	if( cmn_oInformation.bIE ){
		cmnAdd_event( eInput, "keydown",
			function(e){
				if( window.event.keyCode == 9 ){
					var etcRange = document.selection.createRange();
					if( etcRange.text.length ){
						if( window.event.shiftKey ){
							etcRange.text = atkRemove_tabs( etcRange.text );
						}else{
							etcRange.text = atkInsert_tabs( etcRange.text );
						}
					}else{
						etcRange.text = "\t";
					}
					return false;
				}
			}
		);
	}else if( eInput && eInput.selectionStart ){
		var i = atk_aeText_input.length;
		atk_aeText_input[i] = eInput;
		cmnAdd_event( eInput, "keydown",
			function(e){
				if( e.keyCode == 9 ){
					this.bTab_pressed = true;
					var iScroll_top = this.scrollTop;
					var iStart = this.selectionStart;
					var sA = this.value.substring( 0, iStart );
					var sB = this.value.substring( iStart, this.selectionEnd );
					var bSelection = false;
					var sC = this.value.substring( this.selectionEnd, this.value.length );
					if( sB.length ){
						bSelection = true;
						if( e.shiftKey ){
							sB = atkRemove_tabs( sB );
						}else{
							sB = atkInsert_tabs( sB );
						}
					}else{
						sB = "\t";
					}
					this.value = sA + sB + sC;
					this.focus();
					if( bSelection ){
						this.selectionStart = iStart;
						this.selectionEnd = iStart + sB.length;
					}else{
						this.selectionStart = ++iStart;
						this.selectionEnd = iStart;
					}
					this.scrollTop = iScroll_top;
				}
			}
		);
		cmnAdd_event( eInput, "blur",
			function(e){
				if( this.bTab_pressed ){
					this.bTab_pressed = false;
					setTimeout( "atk_aeText_input[" + i + "].focus()", 1 );
				}
			}
		);
	}
	eInput.bTab_pressed = false;

}

function atkRemove_tabs( sText ){
	return sText.replace( /(^|\n)\t/g, "$1" );
}

function atkInsert_tabs( sText ){
	return sText.replace( /(^|\n)([\t\S])/g, "$1\t$2" );
}

var bAllow_tab_key_script_loaded = true;
